/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.editor;

import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.core.ICodeAssist;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.ui.editor.EditorUtility;
import org.eclipse.dltk.internal.ui.editor.ModelElementHyperlink;
import org.eclipse.dltk.internal.ui.editor.ScriptEditor;
import org.eclipse.dltk.internal.ui.text.ScriptWordFinder;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class ModelElementHyperlinkDetector
implements IHyperlinkDetector {
    private ITextEditor fTextEditor;

    public ModelElementHyperlinkDetector(ITextEditor editor) {
        Assert.isNotNull((Object)editor);
        this.fTextEditor = editor;
    }

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        IRegion wordRegion;
        IModelElement input;
        IAction openAction;
        block7: {
            if (region == null || canShowMultipleHyperlinks || !(this.fTextEditor instanceof ScriptEditor)) {
                return null;
            }
            openAction = this.fTextEditor.getAction("OpenEditor");
            if (openAction == null) {
                return null;
            }
            int offset = region.getOffset();
            input = EditorUtility.getEditorInputModelElement((IEditorPart)this.fTextEditor, false);
            if (input == null) {
                return null;
            }
            try {
                IDocument document = this.fTextEditor.getDocumentProvider().getDocument((Object)this.fTextEditor.getEditorInput());
                wordRegion = ScriptWordFinder.findWord(document, offset);
                if (wordRegion != null) break block7;
                return null;
            }
            catch (ModelException modelException) {
                return null;
            }
        }
        IModelElement[] elements = null;
        elements = ((ICodeAssist)input).codeSelect(wordRegion.getOffset(), wordRegion.getLength());
        if (elements != null && elements.length > 0) {
            return new IHyperlink[]{new ModelElementHyperlink(wordRegion, openAction)};
        }
        return null;
    }
}

