/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.corext.refactoring.rename;

import java.util.HashMap;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.IResourceChangeDescriptionFactory;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.dltk.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.dltk.internal.corext.refactoring.ScriptRefactoringArguments;
import org.eclipse.dltk.internal.corext.refactoring.ScriptRefactoringDescriptor;
import org.eclipse.dltk.internal.corext.refactoring.ScriptRefactoringDescriptorComment;
import org.eclipse.dltk.internal.corext.refactoring.changes.DynamicValidationStateChange;
import org.eclipse.dltk.internal.corext.refactoring.changes.RenameResourceChange;
import org.eclipse.dltk.internal.corext.refactoring.code.ScriptableRefactoring;
import org.eclipse.dltk.internal.corext.refactoring.participants.ResourceProcessors;
import org.eclipse.dltk.internal.corext.refactoring.rename.RenameModifications;
import org.eclipse.dltk.internal.corext.refactoring.tagging.ICommentProvider;
import org.eclipse.dltk.internal.corext.refactoring.tagging.INameUpdating;
import org.eclipse.dltk.internal.corext.refactoring.tagging.IScriptableRefactoring;
import org.eclipse.dltk.internal.corext.util.Messages;
import org.eclipse.dltk.internal.corext.util.Resources;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.RenameArguments;
import org.eclipse.ltk.core.refactoring.participants.RenameProcessor;
import org.eclipse.ltk.core.refactoring.participants.ResourceChangeChecker;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;

public class RenameResourceProcessor
extends RenameProcessor
implements IScriptableRefactoring,
ICommentProvider,
INameUpdating {
    static final String ID_RENAME_RESOURCE = "org.eclipse.dltk.ui.rename.resource";
    private IResource fResource;
    private String fNewElementName;
    private String fComment;
    private RenameModifications fRenameModifications;
    public static final String IDENTIFIER = "org.eclipse.dltk.ui.renameResourceProcessor";
    static /* synthetic */ Class class$0;

    public RenameResourceProcessor(IResource resource) {
        this.fResource = resource;
        if (resource != null) {
            this.setNewElementName(resource.getName());
        }
    }

    public void setNewElementName(String newName) {
        Assert.isNotNull((Object)newName);
        this.fNewElementName = newName;
    }

    public String getNewElementName() {
        return this.fNewElementName;
    }

    public String getIdentifier() {
        return IDENTIFIER;
    }

    public boolean isApplicable() throws ModelException {
        return RefactoringAvailabilityTester.isRenameAvailable(this.fResource);
    }

    public String getProcessorName() {
        return RefactoringCoreMessages.RenameResourceProcessor_name;
    }

    public Object[] getElements() {
        return new Object[]{this.fResource};
    }

    public String getCurrentElementName() {
        return this.fResource.getName();
    }

    public String[] getAffectedProjectNatures() throws CoreException {
        return ResourceProcessors.computeAffectedNatures(this.fResource);
    }

    public Object getNewElement() {
        return ResourcesPlugin.getWorkspace().getRoot().findMember(this.createNewPath(this.getNewElementName()));
    }

    public boolean getUpdateReferences() {
        return true;
    }

    public RefactoringParticipant[] loadParticipants(RefactoringStatus status, SharableParticipants shared) throws CoreException {
        return this.fRenameModifications.loadParticipants(status, (RefactoringProcessor)this, this.getAffectedProjectNatures(), shared);
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        return RefactoringStatus.create((IStatus)Resources.checkInSync(this.fResource));
    }

    public RefactoringStatus checkNewElementName(String newName) throws ModelException {
        Assert.isNotNull((Object)newName, (String)"new name");
        IContainer c = this.fResource.getParent();
        if (c == null) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.RenameResourceRefactoring_Internal_Error);
        }
        if (c.findMember(newName) != null) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.RenameResourceRefactoring_alread_exists);
        }
        if (!c.getFullPath().isValidSegment(newName)) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.RenameResourceRefactoring_invalidName);
        }
        RefactoringStatus result = RefactoringStatus.create((IStatus)c.getWorkspace().validateName(newName, this.fResource.getType()));
        if (!result.hasFatalError()) {
            result.merge(RefactoringStatus.create((IStatus)c.getWorkspace().validatePath(this.createNewPath(newName), this.fResource.getType())));
        }
        return result;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws ModelException {
        RefactoringStatus refactoringStatus;
        pm.beginTask("", 1);
        try {
            this.fRenameModifications = new RenameModifications();
            this.fRenameModifications.rename(this.fResource, new RenameArguments(this.getNewElementName(), this.getUpdateReferences()));
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ltk.core.refactoring.participants.ResourceChangeChecker");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ResourceChangeChecker checker = (ResourceChangeChecker)context.getChecker((Class)clazz);
            IResourceChangeDescriptionFactory deltaFactory = checker.getDeltaFactory();
            this.fRenameModifications.buildDelta(deltaFactory);
            refactoringStatus = new RefactoringStatus();
            Object var5_6 = null;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return refactoringStatus;
    }

    private String createNewPath(String newName) {
        return this.fResource.getFullPath().removeLastSegments(1).append(newName).toString();
    }

    public Change createChange(IProgressMonitor pm) throws ModelException {
        DynamicValidationStateChange dynamicValidationStateChange;
        pm.beginTask("", 1);
        try {
            HashMap<String, String> arguments = new HashMap<String, String>();
            String project = null;
            if (this.fResource.getType() != 4) {
                project = this.fResource.getProject().getName();
            }
            String header = Messages.format(RefactoringCoreMessages.RenameResourceChange_descriptor_description, new String[]{this.fResource.getFullPath().toString(), this.getNewElementName()});
            String description = Messages.format(RefactoringCoreMessages.RenameResourceChange_descriptor_description_short, this.fResource.getName());
            String comment = new ScriptRefactoringDescriptorComment(this, header).asString();
            ScriptRefactoringDescriptor descriptor = new ScriptRefactoringDescriptor(ID_RENAME_RESOURCE, project, description, comment, arguments, 7);
            arguments.put("input", ScriptRefactoringDescriptor.resourceToHandle(project, this.fResource));
            arguments.put("name", this.getNewElementName());
            dynamicValidationStateChange = new DynamicValidationStateChange(new RenameResourceChange(descriptor, this.fResource, this.getNewElementName(), comment));
            Object var8_9 = null;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return dynamicValidationStateChange;
    }

    public RefactoringStatus initialize(RefactoringArguments arguments) {
        String name;
        if (arguments instanceof ScriptRefactoringArguments) {
            ScriptRefactoringArguments extended = (ScriptRefactoringArguments)arguments;
            String handle = extended.getAttribute("input");
            if (handle != null) {
                this.fResource = ScriptRefactoringDescriptor.handleToResource(extended.getProject(), handle);
                if (this.fResource == null || !this.fResource.exists()) {
                    return ScriptableRefactoring.createInputFatalStatus(this.fResource, this.getRefactoring().getName(), ID_RENAME_RESOURCE);
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "input"));
            }
            name = extended.getAttribute("name");
            if (name == null || "".equals(name)) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "name"));
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InitializableRefactoring_inacceptable_arguments);
        }
        this.setNewElementName(name);
        return new RefactoringStatus();
    }

    public boolean canEnableComment() {
        return true;
    }

    public String getComment() {
        return this.fComment;
    }

    public void setComment(String comment) {
        this.fComment = comment;
    }
}

