/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.console;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dltk.console.IScriptInterpreter;

public class ScriptInterpreterManager {
    private static ScriptInterpreterManager instance;

    protected IScriptInterpreter findScriptInterpreter(String natureId) throws CoreException {
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IExtensionPoint ep = reg.getExtensionPoint("org.eclipse.dltk.console.scriptInterpreter");
        IExtension[] extensions = ep.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IExtension ext = extensions[i];
            IConfigurationElement[] ce = ext.getConfigurationElements();
            int j = 0;
            while (j < ce.length) {
                if (natureId.equals(ce[j].getAttribute("natureID"))) {
                    Object obj = ce[j].createExecutableExtension("class");
                    if (obj instanceof IScriptInterpreter) {
                        return (IScriptInterpreter)obj;
                    }
                    return null;
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    public static ScriptInterpreterManager getInstance() {
        if (instance == null) {
            instance = new ScriptInterpreterManager();
        }
        return instance;
    }

    public IScriptInterpreter createInterpreter(String natureId) {
        try {
            return this.findScriptInterpreter(natureId);
        }
        catch (CoreException e) {
            e.printStackTrace();
            return null;
        }
    }
}

