/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.parsers.raw;

import org.eclipse.dltk.tcl.internal.parsers.raw.CodeScanner;
import org.eclipse.dltk.tcl.internal.parsers.raw.ErrorDescription;
import org.eclipse.dltk.tcl.internal.parsers.raw.ISubstitution;
import org.eclipse.dltk.tcl.internal.parsers.raw.SimpleTclParser;
import org.eclipse.dltk.tcl.internal.parsers.raw.TclElement;
import org.eclipse.dltk.tcl.internal.parsers.raw.TclParseException;
import org.eclipse.dltk.tcl.internal.parsers.raw.TclTextUtils;
import org.eclipse.dltk.tcl.internal.parsers.raw.TclWord;

public class VariableSubstitution
extends TclElement
implements ISubstitution {
    public static final int VAR_SIMPLE = 0;
    public static final int VAR_ARRAY = 1;
    public static final int VAR_NAME = 2;
    private String name;
    private TclWord index;
    private int kind;

    public TclWord getIndex() {
        return this.index;
    }

    public String getName() {
        return this.name;
    }

    public static boolean iAm(CodeScanner scanner) {
        int c = scanner.read();
        if (c == -1) {
            return false;
        }
        if (c != 36) {
            scanner.unread();
            return false;
        }
        int c2 = scanner.read();
        scanner.unread();
        if (c2 != -1) {
            scanner.unread();
        }
        return TclTextUtils.isIdentifier(c2) || c2 == 40 || c2 == 123;
    }

    public boolean readMe(CodeScanner input) throws TclParseException {
        if (!VariableSubstitution.iAm(input)) {
            return false;
        }
        this.setStart(input.getPosition());
        this.name = "";
        this.kind = 0;
        input.read();
        int c = input.read();
        if (c == 123) {
            this.kind = 2;
            while (true) {
                if ((c = input.read()) == -1) {
                    throw new TclParseException("unexpected EOF while processing braces variable name", input.getPosition());
                }
                if (c != 125) {
                    this.name = String.valueOf(this.name) + (char)c;
                    continue;
                }
                break;
            }
        } else {
            while (c != -1) {
                if (TclTextUtils.isIdentifier(c)) {
                    this.name = String.valueOf(this.name) + (char)c;
                    c = input.read();
                    continue;
                }
                if (c == 40) {
                    this.kind = 1;
                    TclWord cvb = new TclWord();
                    while (true) {
                        ISubstitution s;
                        if ((s = SimpleTclParser.getCVB(input)) != null) {
                            s.readMe(input);
                            cvb.add(s);
                            continue;
                        }
                        int ch = input.read();
                        if (ch == -1) {
                            boolean cont = SimpleTclParser.handleError(new ErrorDescription("unexpected EOF while processing variable index", input.getPosition(), 0));
                            if (cont) break;
                            throw new TclParseException("unexpected EOF while processing variable index", input.getPosition());
                        }
                        if (ch == 41) break;
                        cvb.add((char)ch);
                    }
                    this.index = cvb;
                    break;
                }
                input.unread();
                break;
            }
        }
        if (!input.isEOF()) {
            this.setEnd(input.getPosition() - 1);
        } else {
            this.setEnd(input.getPosition());
        }
        return true;
    }

    public int getKind() {
        return this.kind;
    }
}

