/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui;

import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.ui.DLTKPluginImages;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;

public class ScriptElementImageDescriptor
extends CompositeImageDescriptor {
    public static final int WARNING = 32;
    public static final int ERROR = 64;
    private Point fSize;
    private int fFlags;
    ImageDescriptor fBaseImage;
    static /* synthetic */ Class class$0;

    public ScriptElementImageDescriptor(ImageDescriptor baseImageDescriptor, int flags, Point size) {
        this.fBaseImage = baseImageDescriptor;
        Assert.isNotNull((Object)this.fBaseImage);
        this.fFlags = flags;
        Assert.isTrue((this.fFlags >= 0 ? 1 : 0) != 0);
        this.fSize = size;
        Assert.isNotNull((Object)this.fSize);
    }

    public void setImageSize(Point size) {
        Assert.isNotNull((Object)size);
        Assert.isTrue((size.x >= 0 && size.y >= 0 ? 1 : 0) != 0);
        this.fSize = size;
    }

    public Point getImageSize() {
        return new Point(this.fSize.x, this.fSize.y);
    }

    protected Point getSize() {
        return this.fSize;
    }

    public boolean equals(Object object) {
        block9: {
            block8: {
                if (object == null) break block8;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.dltk.ui.ScriptElementImageDescriptor");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz.equals(object.getClass())) break block9;
            }
            return false;
        }
        ScriptElementImageDescriptor other = (ScriptElementImageDescriptor)((Object)object);
        if (this.fBaseImage == null) {
            return false;
        }
        return other.fFlags == this.fFlags && this.fBaseImage.equals(other.fBaseImage) == this.fSize.equals((Object)other.fSize);
    }

    public int hashCode() {
        if (this.fBaseImage != null) {
            return this.fBaseImage.hashCode() | this.fSize.hashCode() + this.fFlags;
        }
        return this.fSize.hashCode();
    }

    private ImageData getImageData(ImageDescriptor descriptor) {
        if (this.fBaseImage != null) {
            ImageData data = descriptor.getImageData();
            if (data == null) {
                data = DEFAULT_IMAGE_DATA;
                System.err.println("Image data not available: " + descriptor.toString());
            }
            return data;
        }
        System.err.println("Image data not available: " + descriptor.toString());
        return DEFAULT_IMAGE_DATA;
    }

    protected void drawCompositeImage(int width, int height) {
        ImageData bg = this.getImageData(this.fBaseImage);
        if (bg != null) {
            this.drawImage(bg, 0, 0);
        }
        this.drawBottomLeft();
    }

    private void drawBottomLeft() {
        ImageData data;
        Point size = this.getSize();
        int x = 0;
        if ((this.fFlags & 0x40) != 0) {
            data = this.getImageData(DLTKPluginImages.DESC_OVR_ERROR);
            this.drawImage(data, x, size.y - data.height);
            x += data.width;
        }
        if ((this.fFlags & 0x20) != 0) {
            data = this.getImageData(DLTKPluginImages.DESC_OVR_WARNING);
            this.drawImage(data, x, size.y - data.height);
            x += data.width;
        }
    }
}

