/*******************************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 
 *******************************************************************************/
package org.eclipse.dltk.internal.core;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.dltk.core.IModelElement;

public class ClassBasedDLTKExtensionManager extends BasicDLTKExtensionManager {

	private static final String CLASS_ATTR = "class";

	public ClassBasedDLTKExtensionManager(String extensionPoint) {
		super(extensionPoint);
	}

	public Object getObject(String natureId) {
		return getInitObject(getElementInfo(natureId));
	}

	public Object getInitObject(ElementInfo ext) {
		try {
			if (ext != null) {
				if (ext.object != null) {
					return ext.object;
				}

				IConfigurationElement cfg = (IConfigurationElement) ext.config;
				Object object = createObject(cfg);
				ext.object = object;
				return object;
			}
		} catch (CoreException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return null;
	}

	protected Object createObject(IConfigurationElement cfg)
			throws CoreException {
		return cfg.createExecutableExtension(CLASS_ATTR);
	}

	public Object getObject(IModelElement element) {
		if (element.getElementType() == IModelElement.SCRIPT_MODEL) {
			return null;
		}
		IProject project = element.getScriptProject().getProject();
		String natureId = findScriptNature(project);
		if (natureId != null) {
			Object toolkit = getObject(natureId);
			if (toolkit != null) {
				return toolkit;
			}
		}
		return null;
	}

	public Object getObjectLower(String natureID) {
		ElementInfo ext = this.getElementInfo(natureID);
		if (ext.oldInfo == null) {
			return null;
		}
		return getInitObject(ext.oldInfo);
	}
}
