/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.text.blocks;

import org.eclipse.dltk.ui.text.blocks.IBlockSet;
import org.eclipse.dltk.ui.text.blocks.Keyword;
import org.eclipse.dltk.ui.text.blocks.KeywordRole;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;

public class Instance {
    private int begOffset = -1;
    private int midOffset = -1;
    private int endOffset = -1;
    private int begLength = -1;
    private int midLength = -1;
    private int endLength = -1;
    private IBlockSet blockSet;

    public Instance(IBlockSet rootBlockSet, Keyword keyword, int offset) {
        this.blockSet = rootBlockSet;
        if (this.tryJoinAsRightPeer(keyword, offset) != JoinResult.HANDLED) {
            throw new AssertionError((Object)"Keyword matching problems (internal error)");
        }
    }

    public JoinResult tryJoinAsRightPeer(Instance instance, boolean allowOverridingMiddle) {
        boolean endPossible;
        boolean begKnown = this.begOffset >= 0;
        boolean midKnown = this.midOffset >= 0;
        boolean endKnown = this.endOffset >= 0;
        boolean begJoin = !begKnown && instance.begOffset >= 0;
        boolean midJoin = instance.midOffset >= 0;
        boolean endJoin = !endKnown && instance.endOffset >= 0;
        boolean begPossible = begJoin && (midKnown || endKnown);
        boolean midPossible = midJoin && (!midKnown || allowOverridingMiddle);
        boolean bl = endPossible = endJoin && (midKnown || begKnown);
        if (!(begPossible || midPossible || endPossible)) {
            return JoinResult.UNHANDLED;
        }
        IBlockSet newBlockSet = this.blockSet.intersect(instance.getBlockSet());
        if (newBlockSet.isEmpty()) {
            return JoinResult.UNHANDLED;
        }
        if (begPossible) {
            this.begOffset = instance.begOffset;
            this.begLength = instance.begLength;
        }
        if (midPossible) {
            this.midOffset = instance.midOffset;
            this.midLength = instance.midLength;
        }
        if (endPossible) {
            this.endOffset = instance.endOffset;
            this.endLength = instance.endLength;
        }
        if (this.isFullyStuffed()) {
            return JoinResult.HANDLED_PLEASE_DISCARD;
        }
        return JoinResult.HANDLED;
    }

    public JoinResult tryJoinAsRightPeer(Keyword keyword, int offset) {
        switch (keyword.getRole().id()) {
            case 0: {
                if (this.begOffset < 0) break;
                return JoinResult.UNHANDLED;
            }
            case 1: {
                if (this.endOffset < 0) break;
                return JoinResult.UNHANDLED;
            }
        }
        IBlockSet newBlockSet = this.blockSet.narrowByKeyword(keyword);
        if (newBlockSet.isEmpty()) {
            return JoinResult.UNHANDLED;
        }
        this.assignOffset(keyword.getRole(), offset, keyword.getText().length());
        if (this.isFullyStuffed()) {
            return JoinResult.HANDLED_PLEASE_DISCARD;
        }
        return JoinResult.HANDLED;
    }

    public boolean isFullyStuffed() {
        return this.begOffset >= 0 && this.endOffset >= 0;
    }

    private void assignOffset(KeywordRole role, int offset, int length) {
        switch (role.id()) {
            case 0: {
                this.begOffset = offset;
                this.begLength = length;
                break;
            }
            case 2: {
                this.midOffset = offset;
                this.midLength = length;
                break;
            }
            case 1: {
                this.endOffset = offset;
                this.endLength = length;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    public int getOffset(KeywordRole role) {
        switch (role.id()) {
            case 0: {
                return this.begOffset;
            }
            case 2: {
                return this.midOffset;
            }
            case 1: {
                return this.endOffset;
            }
        }
        throw new AssertionError();
    }

    public int getLength(KeywordRole role) {
        switch (role.id()) {
            case 0: {
                return this.begLength;
            }
            case 2: {
                return this.midLength;
            }
            case 1: {
                return this.endLength;
            }
        }
        throw new AssertionError();
    }

    public int getBeginningLength() {
        return this.begLength;
    }

    public int getBeginningOffset() {
        return this.begOffset;
    }

    public IBlockSet getBlockSet() {
        return this.blockSet;
    }

    public int getEndingLength() {
        return this.endLength;
    }

    public int getEndingOffset() {
        return this.endOffset;
    }

    public int getMiddleLength() {
        return this.midLength;
    }

    public int getMiddleOffset() {
        return this.midOffset;
    }

    public void addToDebugString(StringBuffer r, IDocument document) {
        try {
            if (this.begOffset >= 0) {
                r.append(document.get(this.begOffset, this.begLength));
            }
            if (this.midOffset >= 0) {
                r.append(':');
                r.append(document.get(this.midOffset, this.midLength));
            }
            if (this.endOffset >= 0) {
                r.append('/');
                r.append(document.get(this.endOffset, this.endLength));
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public static abstract class JoinResult {
        public static final int UNHANDLED_ID = 0;
        public static final int HANDLED_ID = 1;
        public static final int HANDLED_PLEASE_DISCARD_ID = 3;
        public static final int STOP_SEARCH_ID = 2;
        public static final JoinResult UNHANDLED = new JoinResult(){

            public int getId() {
                return 0;
            }
        };
        public static final JoinResult HANDLED = new JoinResult(){

            public int getId() {
                return 1;
            }
        };
        public static final JoinResult HANDLED_PLEASE_DISCARD = new JoinResult(){

            public int getId() {
                return 3;
            }
        };
        public static final JoinResult STOP_SEARCH = new JoinResult(){

            public int getId() {
                return 2;
            }
        };

        private JoinResult() {
        }

        public abstract int getId();
    }
}

