/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.search;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IBuildpathContainer;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.dltk.internal.corext.util.Messages;
import org.eclipse.dltk.internal.ui.browsing.LogicalPackage;
import org.eclipse.dltk.internal.ui.search.SearchMessages;
import org.eclipse.dltk.internal.ui.search.WorkingSetComparator;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.IWorkingSetSelectionDialog;

public class DLTKSearchScopeFactory {
    private static DLTKSearchScopeFactory fgInstance;
    private final IDLTKSearchScope EMPTY_SCOPE = SearchEngine.createSearchScope((IModelElement[])new IModelElement[0]);
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    private DLTKSearchScopeFactory() {
    }

    public static DLTKSearchScopeFactory getInstance() {
        if (fgInstance == null) {
            fgInstance = new DLTKSearchScopeFactory();
        }
        return fgInstance;
    }

    public IWorkingSet[] queryWorkingSets() throws ModelException {
        IWorkingSet[] workingSets;
        Shell shell = DLTKUIPlugin.getActiveWorkbenchShell();
        if (shell == null) {
            return null;
        }
        IWorkingSetSelectionDialog dialog = PlatformUI.getWorkbench().getWorkingSetManager().createWorkingSetSelectionDialog(shell, true);
        if (dialog.open() == 0 && (workingSets = dialog.getSelection()).length > 0) {
            return workingSets;
        }
        return null;
    }

    public IDLTKSearchScope createSearchScope(IWorkingSet[] workingSets, boolean includeInterp, IDLTKLanguageToolkit toolkit) {
        if (workingSets == null || workingSets.length < 1) {
            return this.EMPTY_SCOPE;
        }
        HashSet modelElements = new HashSet(workingSets.length * 10);
        int i = 0;
        while (i < workingSets.length) {
            IWorkingSet workingSet = workingSets[i];
            if (workingSet.isEmpty() && workingSet.isAggregateWorkingSet()) {
                return this.createWorkspaceScope(includeInterp, toolkit);
            }
            this.addModelElements(modelElements, workingSet);
            ++i;
        }
        return this.createSearchScope(modelElements, includeInterp);
    }

    public IDLTKSearchScope createSearchScope(IWorkingSet workingSet, boolean includeInterp, IDLTKLanguageToolkit toolkit) {
        HashSet modelElements = new HashSet(10);
        if (workingSet.isEmpty() && workingSet.isAggregateWorkingSet()) {
            return this.createWorkspaceScope(includeInterp, toolkit);
        }
        this.addModelElements(modelElements, workingSet);
        return this.createSearchScope(modelElements, includeInterp);
    }

    public IDLTKSearchScope createSearchScope(IResource[] resources, boolean includeInterp, IDLTKLanguageToolkit toolkit) {
        if (resources == null) {
            return this.EMPTY_SCOPE;
        }
        HashSet modelElements = new HashSet(resources.length);
        this.addModelElements(modelElements, resources);
        return this.createSearchScope(modelElements, includeInterp);
    }

    public IDLTKSearchScope createSearchScope(ISelection selection, boolean includeInterp) {
        return this.createSearchScope(this.getModelElements(selection), includeInterp);
    }

    public IDLTKSearchScope createProjectSearchScope(String[] projectNames, boolean includeInterp) {
        ArrayList<IScriptProject> res = new ArrayList<IScriptProject>();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        int i = 0;
        while (i < projectNames.length) {
            IScriptProject project = DLTKCore.create((IProject)root.getProject(projectNames[i]));
            if (project.exists()) {
                res.add(project);
            }
            ++i;
        }
        return this.createSearchScope(res, includeInterp);
    }

    public IDLTKSearchScope createProjectSearchScope(IScriptProject project, boolean includeInterp) {
        return SearchEngine.createSearchScope((IModelElement[])new IModelElement[]{project}, (int)DLTKSearchScopeFactory.getSearchFlags(includeInterp));
    }

    public IDLTKSearchScope createProjectSearchScope(IEditorInput editorInput, boolean includeInterp) {
        IScriptProject project;
        IModelElement elem = DLTKUIPlugin.getEditorInputModelElement(editorInput);
        if (elem != null && (project = elem.getScriptProject()) != null) {
            return this.createProjectSearchScope(project, includeInterp);
        }
        return this.EMPTY_SCOPE;
    }

    public String getWorkspaceScopeDescription(boolean includeInterp) {
        return includeInterp ? SearchMessages.WorkspaceScope : SearchMessages.WorkspaceScopeNoInterpreterEnvironment;
    }

    public String getProjectScopeDescription(String[] projectNames, boolean includeInterp) {
        String scopeDescription;
        if (projectNames.length == 0) {
            return SearchMessages.DLTKSearchScopeFactory_undefined_projects;
        }
        if (projectNames.length == 1) {
            String label = includeInterp ? SearchMessages.EnclosingProjectScope : SearchMessages.EnclosingProjectScopeNoInterpreterEnvironment;
            scopeDescription = Messages.format(label, projectNames[0]);
        } else if (projectNames.length == 2) {
            String label = includeInterp ? SearchMessages.EnclosingProjectsScope2 : SearchMessages.EnclosingProjectsScope2NoInterpreterEnvironment;
            scopeDescription = Messages.format(label, new String[]{projectNames[0], projectNames[1]});
        } else {
            String label = includeInterp ? SearchMessages.EnclosingProjectsScope : SearchMessages.EnclosingProjectsScopeNoInterpreterEnvironment;
            scopeDescription = Messages.format(label, new String[]{projectNames[0], projectNames[1]});
        }
        return scopeDescription;
    }

    public String getProjectScopeDescription(IScriptProject project, boolean includeInterp) {
        if (includeInterp) {
            return Messages.format(SearchMessages.ProjectScope, project.getElementName());
        }
        return Messages.format(SearchMessages.ProjectScopeNoInterpreterEnvironment, project.getElementName());
    }

    public String getProjectScopeDescription(IEditorInput editorInput, boolean includeInterp) {
        IScriptProject project;
        IModelElement elem = DLTKUIPlugin.getEditorInputModelElement(editorInput);
        if (elem != null && (project = elem.getScriptProject()) != null) {
            return this.getProjectScopeDescription(project, includeInterp);
        }
        return Messages.format(SearchMessages.ProjectScope, "");
    }

    public String getHierarchyScopeDescription(IType type) {
        return Messages.format(SearchMessages.HierarchyScope, new String[]{type.getElementName()});
    }

    public String getSelectionScopeDescription(IModelElement[] modelElements, boolean includeInterp) {
        String scopeDescription;
        if (modelElements.length == 0) {
            return SearchMessages.DLTKSearchScopeFactory_undefined_selection;
        }
        if (modelElements.length == 1) {
            String label = includeInterp ? SearchMessages.SingleSelectionScope : SearchMessages.SingleSelectionScopeNoInterpreterEnvironment;
            scopeDescription = Messages.format(label, modelElements[0].getElementName());
        } else if (modelElements.length == 1) {
            String label = includeInterp ? SearchMessages.DoubleSelectionScope : SearchMessages.DoubleSelectionScopeNoInterpreterEnvironment;
            scopeDescription = Messages.format(label, new String[]{modelElements[0].getElementName(), modelElements[1].getElementName()});
        } else {
            String label = includeInterp ? SearchMessages.SelectionScope : SearchMessages.SelectionScopeNoInterpreterEnvironment;
            scopeDescription = Messages.format(label, new String[]{modelElements[0].getElementName(), modelElements[1].getElementName()});
        }
        return scopeDescription;
    }

    public String getWorkingSetScopeDescription(IWorkingSet[] workingSets, boolean includeInterp) {
        if (workingSets.length == 0) {
            return SearchMessages.DLTKSearchScopeFactory_undefined_workingsets;
        }
        if (workingSets.length == 1) {
            String label = includeInterp ? SearchMessages.SingleWorkingSetScope : SearchMessages.SingleWorkingSetScopeNoInterpreterEnvironment;
            return Messages.format(label, workingSets[0].getLabel());
        }
        Arrays.sort(workingSets, new WorkingSetComparator());
        if (workingSets.length == 2) {
            String label = includeInterp ? SearchMessages.DoubleWorkingSetScope : SearchMessages.DoubleWorkingSetScopeNoInterpreterEnvironment;
            return Messages.format(label, new String[]{workingSets[0].getLabel(), workingSets[1].getLabel()});
        }
        String label = includeInterp ? SearchMessages.WorkingSetsScope : SearchMessages.WorkingSetsScopeNoInterpreterEnvironment;
        return Messages.format(label, new String[]{workingSets[0].getLabel(), workingSets[1].getLabel()});
    }

    public IProject[] getProjects(IDLTKSearchScope scope) {
        IPath[] paths = scope.enclosingProjectsAndZips();
        HashSet<IResource> temp = new HashSet<IResource>();
        int i = 0;
        while (i < paths.length) {
            IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(paths[i]);
            if (resource != null && resource.getType() == 4) {
                temp.add(resource);
            }
            ++i;
        }
        return temp.toArray(new IProject[temp.size()]);
    }

    public IModelElement[] getModelElements(ISelection selection) {
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            return this.getModelElements(((IStructuredSelection)selection).toArray());
        }
        return new IModelElement[0];
    }

    private IModelElement[] getModelElements(Object[] elements) {
        if (elements.length == 0) {
            return new IModelElement[0];
        }
        HashSet result = new HashSet(elements.length);
        int i = 0;
        while (i < elements.length) {
            Object selectedElement = elements[i];
            if (selectedElement instanceof IModelElement) {
                this.addModelElements(result, (IModelElement)selectedElement);
            } else if (selectedElement instanceof IResource) {
                this.addModelElements(result, (IResource)selectedElement);
            } else if (selectedElement instanceof LogicalPackage) {
                this.addModelElements(result, (LogicalPackage)((Object)selectedElement));
            } else if (selectedElement instanceof IWorkingSet) {
                IWorkingSet ws = (IWorkingSet)selectedElement;
                this.addModelElements(result, ws);
            } else if (selectedElement instanceof IAdaptable) {
                IResource resource;
                IAdaptable iAdaptable = (IAdaptable)selectedElement;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.core.resources.IResource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((resource = (IResource)iAdaptable.getAdapter((Class)clazz)) != null) {
                    this.addModelElements(result, resource);
                }
            }
            ++i;
        }
        return result.toArray(new IModelElement[result.size()]);
    }

    public IDLTKSearchScope createSearchScope(IModelElement[] modelElements, boolean includeInterp) {
        if (modelElements.length == 0) {
            return this.EMPTY_SCOPE;
        }
        return SearchEngine.createSearchScope((IModelElement[])modelElements, (int)DLTKSearchScopeFactory.getSearchFlags(includeInterp));
    }

    private IDLTKSearchScope createSearchScope(Collection modelElements, boolean includeInterp) {
        if (modelElements.isEmpty()) {
            return this.EMPTY_SCOPE;
        }
        IModelElement[] elementArray = modelElements.toArray(new IModelElement[modelElements.size()]);
        return SearchEngine.createSearchScope((IModelElement[])elementArray, (int)DLTKSearchScopeFactory.getSearchFlags(includeInterp));
    }

    private static int getSearchFlags(boolean includeInterp) {
        int flags = 3;
        if (includeInterp) {
            flags |= 4;
        }
        return flags;
    }

    private void addModelElements(Set modelElements, IResource[] resources) {
        int i = 0;
        while (i < resources.length) {
            this.addModelElements(modelElements, resources[i]);
            ++i;
        }
    }

    private void addModelElements(Set modelElements, IResource resource) {
        IModelElement modelElement;
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.dltk.core.IModelElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((modelElement = (IModelElement)resource.getAdapter((Class)clazz)) == null) {
            return;
        }
        if (modelElement.getElementType() == 4) {
            try {
                this.addModelElements(modelElements, ((IFolder)resource).members());
            }
            catch (CoreException coreException) {}
        }
        modelElements.add(modelElement);
    }

    private void addModelElements(Set modelElements, IModelElement modelElement) {
        modelElements.add(modelElement);
    }

    private void addModelElements(Set modelElements, IWorkingSet workingSet) {
        if (workingSet == null) {
            return;
        }
        if (workingSet.isAggregateWorkingSet() && workingSet.isEmpty()) {
            try {
                IScriptProject[] projects = DLTKCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()).getScriptProjects();
                modelElements.addAll(Arrays.asList(projects));
            }
            catch (ModelException e) {
                DLTKUIPlugin.log(e);
            }
            return;
        }
        IAdaptable[] elements = workingSet.getElements();
        int i = 0;
        while (i < elements.length) {
            IModelElement modelElement;
            IAdaptable iAdaptable = elements[i];
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.dltk.core.IModelElement");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((modelElement = (IModelElement)iAdaptable.getAdapter((Class)clazz)) != null) {
                this.addModelElements(modelElements, modelElement);
            } else {
                IResource resource;
                IAdaptable iAdaptable2 = elements[i];
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = Class.forName("org.eclipse.core.resources.IResource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((resource = (IResource)iAdaptable2.getAdapter((Class)clazz2)) != null) {
                    this.addModelElements(modelElements, resource);
                }
            }
            ++i;
        }
    }

    public void addModelElements(Set modelElements, LogicalPackage selectedElement) {
        IScriptFolder[] packages = selectedElement.getFragments();
        int i = 0;
        while (i < packages.length) {
            this.addModelElements(modelElements, (IModelElement)packages[i]);
            ++i;
        }
    }

    public IDLTKSearchScope createWorkspaceScope(boolean includeInterp, IDLTKLanguageToolkit toolkit) {
        if (!includeInterp) {
            try {
                IScriptProject[] projects = DLTKCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()).getScriptProjects();
                return SearchEngine.createSearchScope((IModelElement[])projects, (int)DLTKSearchScopeFactory.getSearchFlags(includeInterp));
            }
            catch (ModelException modelException) {}
        }
        return SearchEngine.createWorkspaceScope((IDLTKLanguageToolkit)toolkit);
    }

    public boolean isInsideInterpreter(IModelElement element) {
        IProjectFragment root = (IProjectFragment)element.getAncestor(3);
        if (root != null) {
            try {
                IBuildpathEntry entry = root.getRawBuildpathEntry();
                if (entry.getEntryKind() == 5) {
                    IBuildpathContainer container = DLTKCore.getBuildpathContainer((IPath)entry.getPath(), (IScriptProject)root.getScriptProject());
                    return container != null && container.getKind() == 3;
                }
                return false;
            }
            catch (ModelException e) {
                DLTKUIPlugin.log(e);
            }
        }
        return true;
    }
}

