/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.internal.ui.text;

import java.util.ArrayList;
import org.eclipse.dltk.ruby.core.text.RubyContext;
import org.eclipse.dltk.ruby.internal.ui.text.RubyGlobalVarRule;
import org.eclipse.dltk.ruby.internal.ui.text.RubyPercentStringRule;
import org.eclipse.dltk.ruby.internal.ui.text.RubySlashRegexpRule;
import org.eclipse.dltk.ruby.internal.ui.text.syntax.RubyContextUtils;
import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.RuleBasedPartitionScanner;
import org.eclipse.jface.text.rules.Token;

public class RubyPartitionScanner
extends RuleBasedPartitionScanner {
    private Token string;
    private Token comment;
    private Token rubyDoc;
    private Token defaultToken = new Token((Object)"__dftl_partition_content_type");

    public RubyPartitionScanner() {
        this.string = new Token((Object)"__ruby_string");
        this.comment = new Token((Object)"__ruby_comment");
        this.rubyDoc = new Token((Object)"__ruby_doc");
        ArrayList<Object> rules = new ArrayList<Object>();
        rules.add(new MultiLineRule("=begin", "=end", (IToken)this.rubyDoc));
        rules.add(new EndOfLineRule("#", (IToken)this.comment));
        rules.add(new MultiLineRule("'", "'", (IToken)this.string, '\\', true));
        rules.add(new MultiLineRule("\"", "\"", (IToken)this.string, '\\', true));
        rules.add(new RubyPercentStringRule((IToken)this.string, false));
        rules.add((Object)new RubySlashRegexpRule((IToken)this.string));
        rules.add(new RubyGlobalVarRule(this.defaultToken));
        IPredicateRule[] result = new IPredicateRule[rules.size()];
        rules.toArray(result);
        this.setPredicateRules(result);
    }

    public int getOffsetForLaterContextLookup() {
        return this.fOffset;
    }

    public RubyContext getCurrentContext() {
        return RubyContextUtils.determineContext(this.fDocument, this.fOffset, 0);
    }

    public RubyContext getContext(int offset) {
        return RubyContextUtils.determineContext(this.fDocument, offset, 0);
    }

    protected Token getToken(String key) {
        if ("__ruby_string".equals(key)) {
            return this.string;
        }
        if ("__ruby_comment".equals(key)) {
            return this.comment;
        }
        if ("__ruby_doc".equals(key)) {
            return this.rubyDoc;
        }
        return null;
    }
}

