/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.ast;

import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.utils.CorePrinter;

public class RubyConstantDeclaration
extends ASTNode {
    private final ASTNode path;
    private final SimpleReference name;
    private final ASTNode value;

    public RubyConstantDeclaration(ASTNode path, SimpleReference name, ASTNode value) {
        this.path = path;
        this.name = name;
        this.value = value;
    }

    public SimpleReference getName() {
        return this.name;
    }

    public ASTNode getPath() {
        return this.path;
    }

    public ASTNode getValue() {
        return this.value;
    }

    public int getKind() {
        return 0;
    }

    public void printNode(CorePrinter output) {
        output.formatPrint("ConstantDeclaration" + this.getSourceRange().toString() + ":(" + this.getName() + ")");
    }

    public void traverse(ASTVisitor pVisitor) throws Exception {
        if (pVisitor.visit((ASTNode)this)) {
            if (this.path != null) {
                this.path.traverse(pVisitor);
            }
            if (this.name != null) {
                this.name.traverse(pVisitor);
            }
            if (this.value != null) {
                this.value.traverse(pVisitor);
            }
            pVisitor.endvisit((ASTNode)this);
        }
    }
}

