/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.debug.core.model;

import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.debug.core.ScriptDebugManager;
import org.eclipse.dltk.debug.core.model.IScriptLineBreakpoint;
import org.eclipse.dltk.debug.core.model.IScriptWatchpoint;
import org.eclipse.dltk.internal.debug.core.model.ScriptLineBreakpoint;
import org.eclipse.dltk.internal.debug.core.model.ScriptMethodEntryBreakpoint;
import org.eclipse.dltk.internal.debug.core.model.ScriptWatchpoint;

public class ScriptDebugModel {
    protected static String getDenbugModelId(IResource resource) {
        String natureId = DLTKLanguageManager.findToolkit((IResource)resource).getNatureId();
        return ScriptDebugManager.getInstance().getDebugModelByNature(natureId);
    }

    public static IScriptLineBreakpoint createLineBreakpoint(IResource resource, int lineNumber, int charStart, int charEnd, int hitCount, boolean register, Map attributes) throws CoreException {
        return new ScriptLineBreakpoint(ScriptDebugModel.getDenbugModelId(resource), resource, lineNumber, charStart, charEnd, hitCount, register);
    }

    public static IScriptLineBreakpoint createMethodEntryBreakpoint(IResource resource, int lineNumber, int charStart, int charEnd, int hitCount, boolean register, Map attributes, String methodName) throws CoreException {
        return new ScriptMethodEntryBreakpoint(ScriptDebugModel.getDenbugModelId(resource), resource, lineNumber, charStart, charEnd, hitCount, register, methodName);
    }

    public static IScriptWatchpoint createWatchPoint(IResource resource, int lineNumber, int start, int end, String fieldName) throws CoreException {
        return new ScriptWatchpoint(ScriptDebugModel.getDenbugModelId(resource), resource, lineNumber, start, end, fieldName);
    }
}

