/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.launching;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class InterpreterConfig {
    private File scriptFile;
    private File workingDirectory;
    private ArrayList interpreterArgs = new ArrayList();
    private ArrayList scriptArgs = new ArrayList();
    private HashMap environment = new HashMap();
    private HashMap properties = new HashMap();

    public InterpreterConfig(File scriptFile) {
        this();
        if (scriptFile == null) {
            throw new IllegalArgumentException();
        }
        this.scriptFile = scriptFile;
    }

    public InterpreterConfig(File scriptFile, File workingDirectory) {
        this();
        if (scriptFile == null) {
            throw new IllegalArgumentException();
        }
        this.scriptFile = scriptFile;
        this.workingDirectory = workingDirectory;
    }

    public InterpreterConfig() {
    }

    public File getScriptFile() {
        return this.scriptFile;
    }

    public void setScriptFile(File file) {
        this.scriptFile = file;
    }

    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    public void setWorkingDirectory(File directory) {
        this.workingDirectory = directory;
    }

    public boolean addInterpreterArg(String arg) {
        return this.interpreterArgs.add(arg);
    }

    public void addInterpreterArgs(String[] args) {
        int i = 0;
        while (i < args.length) {
            this.addInterpreterArg(args[i]);
            ++i;
        }
    }

    public void addInterpreterArgs(List args) {
        this.interpreterArgs.addAll(args);
    }

    public boolean hasInterpreterArg(String arg) {
        return this.interpreterArgs.contains(arg);
    }

    public boolean hasMatchedInterpreterArg(String regex) {
        Iterator it = this.interpreterArgs.iterator();
        while (it.hasNext()) {
            if (!((String)it.next()).matches(regex)) continue;
            return true;
        }
        return false;
    }

    public boolean removeInterpreterArg(String arg) {
        return this.interpreterArgs.remove(arg);
    }

    public List getInterpreterArgs() {
        return (List)this.interpreterArgs.clone();
    }

    public boolean addScriptArg(String arg) {
        return this.scriptArgs.add(arg);
    }

    public void addScriptArgs(String[] args) {
        int i = 0;
        while (i < args.length) {
            this.addScriptArg(args[i]);
            ++i;
        }
    }

    public void addScriptArgs(List args) {
        this.scriptArgs.addAll(args);
    }

    public boolean hasScriptArg(String arg) {
        return this.scriptArgs.contains(arg);
    }

    public boolean removeScriptArg(String arg) {
        return this.scriptArgs.remove(arg);
    }

    public List getScriptArgs() {
        return (List)this.scriptArgs.clone();
    }

    public String addEnvVar(String name, String value) {
        if (name == null || value == null) {
            throw new IllegalArgumentException();
        }
        return this.environment.put(name, value);
    }

    public void addEnvVars(Map vars) {
        this.environment.putAll(vars);
    }

    public String removeEnvVar(String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        return (String)this.environment.remove(name);
    }

    public String getEnvVar(String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        return (String)this.environment.get(name);
    }

    public boolean hasEnvVar(String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        return this.environment.containsKey(name);
    }

    public Map getEnvVars() {
        return (Map)this.environment.clone();
    }

    public String[] getEnvironmentAsStrings() {
        ArrayList<String> list = new ArrayList<String>();
        Iterator it = this.environment.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            String value = (String)this.environment.get(key);
            list.add(String.valueOf(key) + "=" + value);
        }
        return list.toArray(new String[list.size()]);
    }

    public Object setProperty(String name, Object value) {
        return this.properties.put(name, value);
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    public String[] renderCommandLine(String exe) {
        ArrayList<String> items = new ArrayList<String>();
        items.add(exe);
        Iterator it = this.interpreterArgs.iterator();
        while (it.hasNext()) {
            items.add((String)it.next());
        }
        items.add(this.scriptFile.toString());
        it = this.scriptArgs.iterator();
        while (it.hasNext()) {
            items.add((String)it.next());
        }
        return items.toArray(new String[items.size()]);
    }

    public String toString() {
        return "TODO";
    }
}

