/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.activities;

import java.util.Set;
import org.eclipse.ui.activities.ActivityManagerEvent;
import org.eclipse.ui.activities.IActivity;
import org.eclipse.ui.activities.IActivityManager;
import org.eclipse.ui.activities.ICategory;
import org.eclipse.ui.activities.IIdentifier;
import org.eclipse.ui.internal.activities.AbstractActivityManager;

public final class ProxyActivityManager
extends AbstractActivityManager {
    private IActivityManager activityManager;

    public ProxyActivityManager(IActivityManager activityManager) {
        if (activityManager == null) {
            throw new NullPointerException();
        }
        this.activityManager = activityManager;
        this.activityManager.addActivityManagerListener(activityManagerEvent -> {
            ActivityManagerEvent proxyActivityManagerEvent = activityManagerEvent.copyFor(this);
            this.fireActivityManagerChanged(proxyActivityManagerEvent);
        });
    }

    @Override
    public IActivity getActivity(String activityId) {
        return this.activityManager.getActivity(activityId);
    }

    @Override
    public ICategory getCategory(String categoryId) {
        return this.activityManager.getCategory(categoryId);
    }

    @Override
    public Set<String> getDefinedActivityIds() {
        return this.activityManager.getDefinedActivityIds();
    }

    @Override
    public Set<String> getDefinedCategoryIds() {
        return this.activityManager.getDefinedCategoryIds();
    }

    @Override
    public Set<String> getEnabledActivityIds() {
        return this.activityManager.getEnabledActivityIds();
    }

    @Override
    public IIdentifier getIdentifier(String identifierId) {
        return this.activityManager.getIdentifier(identifierId);
    }
}

