/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.search.ui.viatra.query.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.sphinx.emf.metamodel.IMetaModelDescriptor;
import org.eclipse.sphinx.emf.metamodel.services.AbstractMetaModelService;
import org.eclipse.sphinx.emf.model.IModelDescriptor;
import org.eclipse.sphinx.emf.search.ui.ModelSearchMatch;
import org.eclipse.sphinx.emf.search.ui.QuerySpecification;
import org.eclipse.sphinx.emf.search.ui.services.IModelSearchService;
import org.eclipse.sphinx.emf.search.ui.viatra.query.internal.Activator;
import org.eclipse.sphinx.emf.workspace.viatra.query.IWorkspaceViatraQueryEngineHelper;
import org.eclipse.sphinx.emf.workspace.viatra.query.WorkspaceViatraQueryEngineHelper;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.query.runtime.exception.ViatraQueryException;

public abstract class AbstractViatraQueryModelSearchService
extends AbstractMetaModelService
implements IModelSearchService {
    private IWorkspaceViatraQueryEngineHelper workspaceViatraQueryEngineHelper;

    public AbstractViatraQueryModelSearchService(Collection<IMetaModelDescriptor> mmDescriptors) {
        super(mmDescriptors);
    }

    protected IWorkspaceViatraQueryEngineHelper getWorkspaceViatraQueryEngineHelper() {
        if (this.workspaceViatraQueryEngineHelper == null) {
            this.workspaceViatraQueryEngineHelper = this.createWorkspaceViatraQueryEngineHelper();
        }
        return this.workspaceViatraQueryEngineHelper;
    }

    protected IWorkspaceViatraQueryEngineHelper createWorkspaceViatraQueryEngineHelper() {
        return new WorkspaceViatraQueryEngineHelper();
    }

    protected abstract List<ModelSearchMatch> getMatches(QuerySpecification var1, ViatraQueryEngine var2);

    public List<ModelSearchMatch> getMatches(Collection<Resource> resources, QuerySpecification querySpec) {
        ArrayList<ModelSearchMatch> result = new ArrayList<ModelSearchMatch>();
        for (Resource resource : resources) {
            try {
                ViatraQueryEngine engine = this.getWorkspaceViatraQueryEngineHelper().getEngine(resource, true);
                result.addAll(this.getMatches(querySpec, engine));
            }
            catch (ViatraQueryException ex) {
                PlatformLogUtil.logAsError((Plugin)Activator.getPlugin(), (Object)((Object)ex));
            }
        }
        return result;
    }

    public List<ModelSearchMatch> getMatches(IModelDescriptor modelDescriptor, QuerySpecification querySpec) {
        try {
            ViatraQueryEngine engine = this.getWorkspaceViatraQueryEngineHelper().getEngine(modelDescriptor);
            return this.getMatches(querySpec, engine);
        }
        catch (ViatraQueryException ex) {
            PlatformLogUtil.logAsError((Plugin)Activator.getPlugin(), (Object)((Object)ex));
            return Collections.emptyList();
        }
    }
}

