/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.workspace.ui.decorators;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.sphinx.emf.workspace.ui.internal.Activator;
import org.eclipse.sphinx.emf.workspace.ui.viewers.ITreeContentIterator;
import org.eclipse.sphinx.emf.workspace.ui.viewers.TreeContentProviderIterator;
import org.eclipse.sphinx.platform.resources.IProblemMarkerFinder;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;

public class TreeItemDecorationCalculator {
    protected IProblemMarkerFinder problemMarkerFinder;
    private ITreeContentIterator.IItemFilter itemFilter;
    protected Map<Object, DecorationOverlayKind> decorationOverlayCache = new HashMap<Object, DecorationOverlayKind>();

    public TreeItemDecorationCalculator(IProblemMarkerFinder problemMarkerFinder) {
        Assert.isNotNull((Object)problemMarkerFinder);
        this.problemMarkerFinder = problemMarkerFinder;
    }

    public ITreeContentIterator.IItemFilter getItemFilter() {
        return this.itemFilter;
    }

    public void setItemFilter(ITreeContentIterator.IItemFilter itemFilter) {
        this.itemFilter = itemFilter;
    }

    public DecorationOverlayKind getDecorationOverlayKind(ITreeContentProvider contentProvider, Object item) {
        Assert.isNotNull((Object)contentProvider);
        try {
            DecorationOverlayKind itemOverlayKind = this.decorationOverlayCache.get(item);
            if (itemOverlayKind != null) {
                return itemOverlayKind;
            }
            TreeContentProviderIterator iter = new TreeContentProviderIterator(contentProvider, item, this.itemFilter);
            while (iter.hasNext()) {
                Object childItem = iter.next();
                DecorationOverlayKind childItemOverlayKind = this.decorationOverlayCache.get(childItem);
                if (childItemOverlayKind != null) {
                    iter.prune();
                } else {
                    int severity = this.problemMarkerFinder.getSeverity(childItem);
                    childItemOverlayKind = this.getDecorationOverlayKind(severity);
                    if (iter.isRecurrent()) {
                        this.resetCachedAncestorDecorationKinds(contentProvider, childItem, item);
                    } else {
                        this.decorationOverlayCache.put(childItem, childItemOverlayKind);
                        this.updateCachedAncestorDecorationOverlayKinds(contentProvider, childItem, childItemOverlayKind);
                    }
                }
                if (itemOverlayKind == null || childItemOverlayKind.isGreaterThan(itemOverlayKind)) {
                    itemOverlayKind = childItemOverlayKind;
                }
                if (itemOverlayKind == DecorationOverlayKind.ERROR) break;
            }
            this.decorationOverlayCache.put(item, itemOverlayKind);
            this.updateCachedAncestorDecorationOverlayKinds(contentProvider, item, itemOverlayKind);
            return itemOverlayKind;
        }
        catch (CoreException ex) {
            PlatformLogUtil.logAsWarning((Plugin)Activator.getPlugin(), (Object)((Object)ex));
            return DecorationOverlayKind.NONE;
        }
    }

    protected DecorationOverlayKind getDecorationOverlayKind(int severity) {
        switch (severity) {
            case 1: {
                return DecorationOverlayKind.WARNING;
            }
            case 2: {
                return DecorationOverlayKind.ERROR;
            }
        }
        return DecorationOverlayKind.NONE;
    }

    protected void updateCachedAncestorDecorationOverlayKinds(ITreeContentProvider contentProvider, Object object, DecorationOverlayKind newOverlayKind) {
        Assert.isNotNull((Object)contentProvider);
        Assert.isNotNull((Object)((Object)newOverlayKind));
        Object parent = contentProvider.getParent(object);
        while (parent != null) {
            DecorationOverlayKind cachedOverlayKind = this.decorationOverlayCache.get(parent);
            if (cachedOverlayKind == null || !newOverlayKind.isGreaterThan(cachedOverlayKind)) break;
            this.decorationOverlayCache.put(parent, newOverlayKind);
            parent = contentProvider.getParent(parent);
        }
    }

    protected void resetCachedAncestorDecorationKinds(ITreeContentProvider contentProvider, Object object, Object limit) {
        Assert.isNotNull((Object)contentProvider);
        Object parent = contentProvider.getParent(object);
        while (parent != limit && parent != null) {
            this.decorationOverlayCache.remove(parent);
            parent = contentProvider.getParent(parent);
        }
    }

    public void reset() {
        this.decorationOverlayCache.clear();
        this.problemMarkerFinder.reset();
    }

    public static enum DecorationOverlayKind {
        NONE,
        WARNING,
        ERROR;


        public DecorationOverlayKind update(DecorationOverlayKind overlayKind) {
            return this.isLessThan(overlayKind) ? overlayKind : this;
        }

        public boolean isLessThan(DecorationOverlayKind otherOverlayKind) {
            Assert.isNotNull((Object)((Object)otherOverlayKind));
            return this.ordinal() < otherOverlayKind.ordinal();
        }

        public boolean isGreaterThan(DecorationOverlayKind otherOverlayKind) {
            Assert.isNotNull((Object)((Object)otherOverlayKind));
            return this.ordinal() > otherOverlayKind.ordinal();
        }
    }
}

