/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.platform.ui.fields.adapters;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sphinx.platform.messages.PlatformMessages;
import org.eclipse.sphinx.platform.ui.fields.IField;
import org.eclipse.sphinx.platform.ui.fields.adapters.IButtonAdapter;

public abstract class AbstractButtonAdapter
implements IButtonAdapter {
    protected AbstractButtonAdapter() {
    }

    @Override
    public void changeControlPressed(IField field) {
        Assert.isNotNull((Object)field);
        Dialog dialog = this.createDialog();
        int result = dialog.open();
        if (result == 0) {
            this.performOk(field, dialog);
        } else {
            this.performCancel(field, dialog);
        }
    }

    protected final Dialog createDialog() {
        Dialog dialog = this.doCreateDialog();
        if (dialog == null) {
            throw new RuntimeException(NLS.bind((String)PlatformMessages.error_mustNotBeNull, (Object)"dialog"));
        }
        return dialog;
    }

    protected abstract Dialog doCreateDialog();

    protected void performOk(IField field, Dialog dialog) {
    }

    protected void performCancel(IField field, Dialog dialog) {
    }
}

