/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.examples.hummingbird.metamodelgen.operations;

import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.sphinx.emf.metamodelgen.operations.AbstractGenerateFromEcoreOperation;
import org.eclipse.sphinx.emf.serialization.generators.persistencemapping.XMLPersistenceMappingGenerator;
import org.eclipse.sphinx.emf.util.EcorePlatformUtil;
import org.eclipse.sphinx.examples.hummingbird.metamodelgen.internal.messages.Messages;

public class GenerateXMLPersistenceMappingsOperation
extends AbstractGenerateFromEcoreOperation {
    public static final String MAPPED_ECORE_FILE_NAME_POSTFIX = "-mapped";
    public static final Pattern ORIGINAL_ECORE_FILE_BASE_NAME_PATTERN = Pattern.compile("(.*)-mapped(\\.ecore)?$");
    public static final int ORIGINAL_ECORE_FILE_BASE_NAME_GROUP_IDX = 1;
    private EPackage mappedEcoreModel = null;

    public GenerateXMLPersistenceMappingsOperation(IFile ecoreFile) {
        super(Messages.operation_generateXMLPersistenceMappings_label, ecoreFile);
    }

    public GenerateXMLPersistenceMappingsOperation(String label, IFile ecoreFile) {
        super(label, ecoreFile);
    }

    public URI getMappedEcoreFileURI() {
        String mapppedEcoreFileBaseName = String.valueOf(this.ecoreFile.getFullPath().removeFileExtension().lastSegment()) + MAPPED_ECORE_FILE_NAME_POSTFIX;
        IPath mappedEcorePath = this.ecoreFile.getParent().getFullPath().append(mapppedEcoreFileBaseName).addFileExtension("ecore");
        return EcorePlatformUtil.createURI((IPath)mappedEcorePath);
    }

    public void generate(EPackage ecoreModel, IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        XMLPersistenceMappingGenerator xmlPersistenceMappingGenerator = this.createXMLPersistenceMappingGenerator(ecoreModel);
        this.mappedEcoreModel = (EPackage)xmlPersistenceMappingGenerator.execute((IProgressMonitor)progress.newChild(10));
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        this.saveEcoreModel(this.getMappedEcoreFileURI(), this.mappedEcoreModel);
        progress.worked(90);
    }

    protected XMLPersistenceMappingGenerator createXMLPersistenceMappingGenerator(EPackage ecoreModel) {
        return new XMLPersistenceMappingGenerator(ecoreModel);
    }

    public EPackage getMappedEcoreModel() {
        return this.mappedEcoreModel;
    }
}

