/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.examples.hummingbird20.diagram.gmf.navigator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.WorkspaceEditingDomainFactory;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.sphinx.examples.hummingbird20.diagram.gmf.navigator.Hummingbird20AbstractNavigatorItem;
import org.eclipse.sphinx.examples.hummingbird20.diagram.gmf.navigator.Hummingbird20NavigatorGroup;
import org.eclipse.sphinx.examples.hummingbird20.diagram.gmf.navigator.Hummingbird20NavigatorItem;
import org.eclipse.sphinx.examples.hummingbird20.diagram.gmf.part.Hummingbird20VisualIDRegistry;
import org.eclipse.sphinx.examples.hummingbird20.diagram.gmf.part.Messages;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonContentProvider;

public class Hummingbird20NavigatorContentProvider
implements ICommonContentProvider {
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private Viewer myViewer;
    private AdapterFactoryEditingDomain myEditingDomain;
    private WorkspaceSynchronizer myWorkspaceSynchronizer;
    private Runnable myViewerRefreshRunnable;

    public Hummingbird20NavigatorContentProvider() {
        TransactionalEditingDomain editingDomain = WorkspaceEditingDomainFactory.INSTANCE.createEditingDomain();
        this.myEditingDomain = (AdapterFactoryEditingDomain)editingDomain;
        this.myEditingDomain.setResourceToReadOnlyMap((Map)new HashMap(){

            @Override
            public Object get(Object key) {
                if (!this.containsKey(key)) {
                    this.put(key, Boolean.TRUE);
                }
                return super.get(key);
            }
        });
        this.myViewerRefreshRunnable = new Runnable(){

            @Override
            public void run() {
                if (Hummingbird20NavigatorContentProvider.this.myViewer != null) {
                    Hummingbird20NavigatorContentProvider.this.myViewer.refresh();
                }
            }
        };
        this.myWorkspaceSynchronizer = new WorkspaceSynchronizer(editingDomain, new WorkspaceSynchronizer.Delegate(){

            public void dispose() {
            }

            public boolean handleResourceChanged(Resource resource) {
                Hummingbird20NavigatorContentProvider.this.unloadAllResources();
                Hummingbird20NavigatorContentProvider.this.asyncRefresh();
                return true;
            }

            public boolean handleResourceDeleted(Resource resource) {
                Hummingbird20NavigatorContentProvider.this.unloadAllResources();
                Hummingbird20NavigatorContentProvider.this.asyncRefresh();
                return true;
            }

            public boolean handleResourceMoved(Resource resource, URI newURI) {
                Hummingbird20NavigatorContentProvider.this.unloadAllResources();
                Hummingbird20NavigatorContentProvider.this.asyncRefresh();
                return true;
            }
        });
    }

    public void dispose() {
        this.myWorkspaceSynchronizer.dispose();
        this.myWorkspaceSynchronizer = null;
        this.myViewerRefreshRunnable = null;
        this.myViewer = null;
        this.unloadAllResources();
        ((TransactionalEditingDomain)this.myEditingDomain).dispose();
        this.myEditingDomain = null;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.myViewer = viewer;
    }

    void unloadAllResources() {
        for (Resource nextResource : this.myEditingDomain.getResourceSet().getResources()) {
            nextResource.unload();
        }
    }

    void asyncRefresh() {
        if (this.myViewer != null && !this.myViewer.getControl().isDisposed()) {
            this.myViewer.getControl().getDisplay().asyncExec(this.myViewerRefreshRunnable);
        }
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void restoreState(IMemento aMemento) {
    }

    public void saveState(IMemento aMemento) {
    }

    public void init(ICommonContentExtensionSite aConfig) {
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IFile) {
            IFile file = (IFile)parentElement;
            URI fileURI = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
            Resource resource = this.myEditingDomain.getResourceSet().getResource(fileURI, true);
            ArrayList result = new ArrayList();
            ArrayList<View> topViews = new ArrayList<View>(resource.getContents().size());
            for (EObject o : resource.getContents()) {
                if (!(o instanceof View)) continue;
                topViews.add((View)o);
            }
            return result.toArray();
        }
        if (parentElement instanceof Hummingbird20NavigatorGroup) {
            Hummingbird20NavigatorGroup group = (Hummingbird20NavigatorGroup)((Object)parentElement);
            return group.getChildren();
        }
        if (parentElement instanceof Hummingbird20NavigatorItem) {
            Hummingbird20NavigatorItem navigatorItem = (Hummingbird20NavigatorItem)((Object)parentElement);
            if (navigatorItem.isLeaf() || !this.isOwnView(navigatorItem.getView())) {
                return EMPTY_ARRAY;
            }
            return this.getViewChildren(navigatorItem.getView(), parentElement);
        }
        return EMPTY_ARRAY;
    }

    private Object[] getViewChildren(View view, Object parentElement) {
        switch (Hummingbird20VisualIDRegistry.getVisualID(view)) {
            case 4001: {
                LinkedList<Hummingbird20NavigatorGroup> result = new LinkedList<Hummingbird20NavigatorGroup>();
                Edge sv = (Edge)view;
                Hummingbird20NavigatorGroup target = new Hummingbird20NavigatorGroup(Messages.NavigatorGroupName_Connection_4001_target, "icons/linkTargetNavigatorGroup.gif", parentElement);
                Hummingbird20NavigatorGroup source = new Hummingbird20NavigatorGroup(Messages.NavigatorGroupName_Connection_4001_source, "icons/linkSourceNavigatorGroup.gif", parentElement);
                Collection<View> connectedViews = this.getLinksTargetByType(Collections.singleton(sv), Hummingbird20VisualIDRegistry.getType(2001));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(sv), Hummingbird20VisualIDRegistry.getType(2001));
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                if (!target.isEmpty()) {
                    result.add(target);
                }
                if (!source.isEmpty()) {
                    result.add(source);
                }
                return result.toArray();
            }
            case 2001: {
                LinkedList<Hummingbird20NavigatorGroup> result = new LinkedList<Hummingbird20NavigatorGroup>();
                Node sv = (Node)view;
                Hummingbird20NavigatorGroup incominglinks = new Hummingbird20NavigatorGroup(Messages.NavigatorGroupName_Component_2001_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
                Hummingbird20NavigatorGroup outgoinglinks = new Hummingbird20NavigatorGroup(Messages.NavigatorGroupName_Component_2001_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
                Collection<View> connectedViews = this.getIncomingLinksByType(Collections.singleton(sv), Hummingbird20VisualIDRegistry.getType(4001));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(sv), Hummingbird20VisualIDRegistry.getType(4001));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                if (!incominglinks.isEmpty()) {
                    result.add(incominglinks);
                }
                if (!outgoinglinks.isEmpty()) {
                    result.add(outgoinglinks);
                }
                return result.toArray();
            }
            case 1000: {
                LinkedList<Hummingbird20AbstractNavigatorItem> result = new LinkedList<Hummingbird20AbstractNavigatorItem>();
                Diagram sv = (Diagram)view;
                Hummingbird20NavigatorGroup links = new Hummingbird20NavigatorGroup(Messages.NavigatorGroupName_Application_1000_links, "icons/linksNavigatorGroup.gif", parentElement);
                Collection<View> connectedViews = this.getChildrenByType(Collections.singleton(sv), Hummingbird20VisualIDRegistry.getType(2001));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getDiagramLinksByType(Collections.singleton(sv), Hummingbird20VisualIDRegistry.getType(4001));
                links.addChildren(this.createNavigatorItems(connectedViews, (Object)links, false));
                if (!links.isEmpty()) {
                    result.add(links);
                }
                return result.toArray();
            }
        }
        return EMPTY_ARRAY;
    }

    private Collection<View> getLinksSourceByType(Collection<Edge> edges, String type) {
        LinkedList<View> result = new LinkedList<View>();
        for (Edge nextEdge : edges) {
            View nextEdgeSource = nextEdge.getSource();
            if (!type.equals(nextEdgeSource.getType()) || !this.isOwnView(nextEdgeSource)) continue;
            result.add(nextEdgeSource);
        }
        return result;
    }

    private Collection<View> getLinksTargetByType(Collection<Edge> edges, String type) {
        LinkedList<View> result = new LinkedList<View>();
        for (Edge nextEdge : edges) {
            View nextEdgeTarget = nextEdge.getTarget();
            if (!type.equals(nextEdgeTarget.getType()) || !this.isOwnView(nextEdgeTarget)) continue;
            result.add(nextEdgeTarget);
        }
        return result;
    }

    private Collection<View> getOutgoingLinksByType(Collection<? extends View> nodes, String type) {
        LinkedList<View> result = new LinkedList<View>();
        for (View view : nodes) {
            result.addAll(this.selectViewsByType((Collection<View>)view.getSourceEdges(), type));
        }
        return result;
    }

    private Collection<View> getIncomingLinksByType(Collection<? extends View> nodes, String type) {
        LinkedList<View> result = new LinkedList<View>();
        for (View view : nodes) {
            result.addAll(this.selectViewsByType((Collection<View>)view.getTargetEdges(), type));
        }
        return result;
    }

    private Collection<View> getChildrenByType(Collection<? extends View> nodes, String type) {
        LinkedList<View> result = new LinkedList<View>();
        for (View view : nodes) {
            result.addAll(this.selectViewsByType((Collection<View>)view.getChildren(), type));
        }
        return result;
    }

    private Collection<View> getDiagramLinksByType(Collection<Diagram> diagrams, String type) {
        ArrayList<View> result = new ArrayList<View>();
        for (Diagram nextDiagram : diagrams) {
            result.addAll(this.selectViewsByType((Collection<View>)nextDiagram.getEdges(), type));
        }
        return result;
    }

    private Collection<View> selectViewsByType(Collection<View> views, String type) {
        ArrayList<View> result = new ArrayList<View>();
        for (View nextView : views) {
            if (!type.equals(nextView.getType()) || !this.isOwnView(nextView)) continue;
            result.add(nextView);
        }
        return result;
    }

    private boolean isOwnView(View view) {
        return "Hummingbird20".equals(Hummingbird20VisualIDRegistry.getModelID(view));
    }

    private Collection<Hummingbird20NavigatorItem> createNavigatorItems(Collection<View> views, Object parent, boolean isLeafs) {
        ArrayList<Hummingbird20NavigatorItem> result = new ArrayList<Hummingbird20NavigatorItem>(views.size());
        for (View nextView : views) {
            result.add(new Hummingbird20NavigatorItem(nextView, parent, isLeafs));
        }
        return result;
    }

    public Object getParent(Object element) {
        if (element instanceof Hummingbird20AbstractNavigatorItem) {
            Hummingbird20AbstractNavigatorItem abstractNavigatorItem = (Hummingbird20AbstractNavigatorItem)((Object)element);
            return abstractNavigatorItem.getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return element instanceof IFile || this.getChildren(element).length > 0;
    }
}

