/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.ui.actions.providers;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.sphinx.emf.ui.actions.BasicOpenInEditorAction;
import org.eclipse.sphinx.emf.ui.actions.providers.BasicActionProvider;
import org.eclipse.sphinx.emf.ui.actions.providers.OpenWithMenu;
import org.eclipse.sphinx.emf.ui.internal.messages.Messages;
import org.eclipse.sphinx.platform.ui.util.SelectionUtil;
import org.eclipse.ui.IActionBars;

public class BasicEditorActionProvider
extends BasicActionProvider {
    protected BasicOpenInEditorAction openInEditorAction;
    protected IDoubleClickListener doubleClickListener = new IDoubleClickListener(){

        public void doubleClick(DoubleClickEvent evt) {
            ISelection selection = evt.getSelection();
            if (selection instanceof IStructuredSelection && BasicEditorActionProvider.this.openInEditorAction.isEnabled()) {
                BasicEditorActionProvider.this.openInEditorAction.run();
            }
        }
    };

    public void doInit() {
        this.openInEditorAction = new BasicOpenInEditorAction();
        if (this.selectionProvider != null) {
            this.selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.openInEditorAction);
            ISelection selection = this.selectionProvider.getSelection();
            IStructuredSelection structuredSelection = SelectionUtil.getStructuredSelection((ISelection)selection);
            this.openInEditorAction.updateSelection(structuredSelection);
        }
        if (this.viewer instanceof StructuredViewer) {
            ((StructuredViewer)this.viewer).addDoubleClickListener(this.doubleClickListener);
        }
    }

    public void fillContextMenu(IMenuManager menuManager) {
        Object selected;
        menuManager.appendToGroup("group.open", (IContributionItem)new ActionContributionItem((IAction)this.openInEditorAction));
        IStructuredSelection selection = SelectionUtil.getStructuredSelection((ISelection)this.getContext().getSelection());
        if (selection.size() == 1 && (selected = selection.getFirstElement()) instanceof EObject && this.workbenchPart != null) {
            MenuManager submenu = new MenuManager(Messages.label_openWithMenu);
            submenu.add((IContributionItem)new OpenWithMenu(this.workbenchPart.getSite().getPage(), (EObject)selected));
            menuManager.appendToGroup("group.openWith", (IContributionItem)submenu);
        }
    }

    public void fillActionBars(IActionBars actionBars) {
        super.fillActionBars(actionBars);
        actionBars.setGlobalActionHandler("org.eclipse.ui.navigator.Open", (IAction)this.openInEditorAction);
    }

    public void dispose() {
        super.dispose();
        if (this.viewer instanceof StructuredViewer) {
            ((StructuredViewer)this.viewer).removeDoubleClickListener(this.doubleClickListener);
        }
        if (this.selectionProvider != null && this.openInEditorAction != null) {
            this.selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.openInEditorAction);
        }
    }
}

