/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.mwe.dynamic.ui.handlers;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sphinx.emf.mwe.dynamic.operations.BasicWorkflowRunnerOperation;
import org.eclipse.sphinx.emf.mwe.dynamic.operations.IWorkflowRunnerOperation;
import org.eclipse.sphinx.emf.mwe.dynamic.ui.internal.messages.Messages;
import org.eclipse.sphinx.emf.mwe.dynamic.ui.util.WorkflowRunnerActionHandlerHelper;
import org.eclipse.sphinx.platform.jobs.WorkspaceOperationWorkspaceJob;
import org.eclipse.sphinx.platform.operations.IWorkspaceOperation;
import org.eclipse.sphinx.platform.ui.operations.RunnableWithProgressAdapter;
import org.eclipse.sphinx.platform.ui.util.ExtendedPlatformUI;
import org.eclipse.sphinx.platform.ui.util.SelectionUtil;
import org.eclipse.ui.handlers.HandlerUtil;

public class BasicWorkflowRunnerHandler
extends AbstractHandler {
    private IStructuredSelection selection;
    private boolean runInBackground;
    protected WorkflowRunnerActionHandlerHelper helper;

    public BasicWorkflowRunnerHandler() {
        this.setRunInBackground(false);
        this.helper = new WorkflowRunnerActionHandlerHelper();
    }

    public boolean isRunInBackground() {
        return this.runInBackground;
    }

    public void setRunInBackground(boolean runInBackground) {
        this.runInBackground = runInBackground;
    }

    protected IStructuredSelection getStructuredSelection() {
        return this.selection;
    }

    protected String getOperationName() {
        return Messages.operation_runWorkflow_label;
    }

    protected IWorkflowRunnerOperation createWorkflowRunnerOperation() {
        Object workflow = this.helper.getWorkflow(this.getStructuredSelection());
        if (workflow == null) {
            workflow = this.helper.promptForWorkflow(this.getStructuredSelection());
        }
        BasicWorkflowRunnerOperation operation = new BasicWorkflowRunnerOperation(this.getOperationName(), workflow);
        List<URI> modelURIs = this.helper.getModelURIs(this.getStructuredSelection());
        operation.getModelURIs().addAll(modelURIs);
        return operation;
    }

    protected WorkspaceJob createWorkspaceOperationJob(IWorkflowRunnerOperation operation) {
        return new WorkspaceOperationWorkspaceJob((IWorkspaceOperation)operation);
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.selection = SelectionUtil.getStructuredSelection((ISelection)HandlerUtil.getActiveMenuSelection((ExecutionEvent)event));
        ExtendedPlatformUI.showSystemConsole();
        IWorkflowRunnerOperation operation = this.createWorkflowRunnerOperation();
        if (this.isRunInBackground()) {
            WorkspaceJob job = this.createWorkspaceOperationJob(operation);
            job.schedule();
        } else {
            try {
                ProgressMonitorDialog dialog = new ProgressMonitorDialog(ExtendedPlatformUI.getActiveShell());
                dialog.run(true, true, (IRunnableWithProgress)new RunnableWithProgressAdapter((IWorkspaceOperation)operation));
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException ex) {
                throw new ExecutionException(ex.getMessage(), (Throwable)ex);
            }
        }
        return null;
    }
}

