/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.platform.ui.fields;

import org.eclipse.sphinx.platform.ui.fields.BasicField;
import org.eclipse.sphinx.platform.ui.fields.IComboField;
import org.eclipse.sphinx.platform.ui.fields.messages.FieldsMessages;
import org.eclipse.sphinx.platform.ui.internal.util.LayoutUtil;
import org.eclipse.sphinx.platform.ui.widgets.IWidgetFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ComboField
extends BasicField
implements IComboField {
    public static String[] EMPTY_LIST = new String[]{FieldsMessages.field_EmptyListItem};
    private String fText = "";
    private int fSelectionIndex;
    private String[] fItems = new String[0];
    private Combo fComboControl;
    private ModifyListener fModifyListener;
    private int fStyle;
    private boolean firesChangeEvent = true;

    public ComboField() {
        this(false);
    }

    public ComboField(IWidgetFactory widgetFactory) {
        this(widgetFactory, false);
    }

    public ComboField(boolean isEditable) {
        this(null, isEditable);
    }

    public ComboField(int style) {
        this(null, style);
    }

    public ComboField(IWidgetFactory widgetFactory, boolean isEditable) {
        this(widgetFactory, isEditable ? 0 : 8);
    }

    public ComboField(IWidgetFactory widgetFactory, int style) {
        super(widgetFactory);
        this.fStyle = style;
        this.fSelectionIndex = -1;
    }

    @Override
    protected Control[] doFillIntoGrid(Composite parent, int nColumns) {
        Control label = this.getLabelControl(parent, false, 1);
        Combo combo = this.getComboControl(parent, nColumns - 1);
        return new Control[]{label, combo};
    }

    @Override
    protected int getNumberOfControls() {
        return 2;
    }

    @Override
    public boolean setFocus() {
        if (this.isOkToUse((Control)this.fComboControl)) {
            this.fComboControl.setFocus();
        }
        return true;
    }

    protected final Combo getComboControl(Composite parent, int hspan) {
        Combo combo = this.createComboControl(parent, hspan);
        if (combo.getLayoutData() == null) {
            if (this.fUseFormLayout) {
                combo.setLayoutData((Object)LayoutUtil.tableWrapDataForCombo(hspan));
            } else {
                combo.setLayoutData((Object)LayoutUtil.gridDataForCombo(hspan));
            }
        }
        return combo;
    }

    private Combo createComboControl(Composite parent, int hspan) {
        if (this.fComboControl == null) {
            this.assertCompositeNotNull(parent);
            this.fModifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    if (ComboField.this.firesChangeEvent) {
                        ComboField.this.doModifyText(e);
                    }
                }
            };
            SelectionListener selectionListener = new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    if (ComboField.this.firesChangeEvent) {
                        ComboField.this.doSelectionChanged(e);
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            };
            this.fComboControl = this.fWidgetFactory != null ? this.fWidgetFactory.createCombo(parent, this.fStyle, true, hspan) : new Combo(parent, this.fStyle);
            this.fComboControl.setItems(this.fItems);
            if (this.fSelectionIndex != -1) {
                this.fComboControl.select(this.fSelectionIndex);
            } else {
                this.fComboControl.setText(this.fText);
            }
            this.fComboControl.setFont(parent.getFont());
            this.fComboControl.addModifyListener(this.fModifyListener);
            this.fComboControl.addSelectionListener(selectionListener);
            this.fComboControl.setEnabled(this.isEnabled());
        }
        return this.fComboControl;
    }

    private void doModifyText(ModifyEvent e) {
        boolean firesDialogChangedEvent = false;
        if (this.isOkToUse((Control)this.fComboControl)) {
            firesDialogChangedEvent = !this.fComboControl.getText().equals(this.fText) || this.fComboControl.getSelectionIndex() != this.fSelectionIndex;
            this.fText = this.fComboControl.getText();
            this.fSelectionIndex = this.fComboControl.getSelectionIndex();
        }
        if (firesDialogChangedEvent) {
            this.dialogFieldChanged();
        }
    }

    private void doSelectionChanged(SelectionEvent e) {
        boolean firesDialogChangedEvent = false;
        if (this.isOkToUse((Control)this.fComboControl)) {
            firesDialogChangedEvent = !this.fComboControl.getText().equals(this.fText) || this.fComboControl.getSelectionIndex() != this.fSelectionIndex;
            this.fItems = this.fComboControl.getItems();
            this.fText = this.fComboControl.getText();
            this.fSelectionIndex = this.fComboControl.getSelectionIndex();
        }
        if (firesDialogChangedEvent) {
            this.dialogFieldChanged();
        }
    }

    @Override
    protected void updateEnableState() {
        super.updateEnableState();
        if (this.isOkToUse((Control)this.fComboControl)) {
            this.fComboControl.setEnabled(this.isEnabled());
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.isOkToUse((Control)this.fComboControl)) {
            this.fComboControl.dispose();
        }
    }

    @Override
    public String[] getItems() {
        return this.fItems;
    }

    @Override
    public void setItems(String[] items) {
        this.setItems(items, false);
    }

    public void setItems(String[] items, boolean silent) {
        boolean previousState = this.firesChangeEvent;
        this.firesChangeEvent = !silent;
        this.fItems = items;
        if (this.isOkToUse((Control)this.fComboControl)) {
            this.fComboControl.setItems(items);
        }
        if (this.firesChangeEvent) {
            this.dialogFieldChanged();
        }
        this.firesChangeEvent = previousState;
    }

    public String getText() {
        return this.fText;
    }

    @Override
    public void setText(String text) {
        this.fText = text;
        if (this.isOkToUse((Control)this.fComboControl)) {
            this.fComboControl.setText(text);
        } else {
            this.dialogFieldChanged();
        }
    }

    @Override
    public boolean selectItem(int index) {
        return this.selectItem(index, false);
    }

    public boolean selectItem(int index, boolean silent) {
        boolean success = false;
        if (this.isOkToUse((Control)this.fComboControl)) {
            boolean previousState = this.firesChangeEvent;
            this.firesChangeEvent = !silent;
            this.fComboControl.select(index);
            this.firesChangeEvent = previousState;
            success = this.fComboControl.getSelectionIndex() == index;
        } else if (index >= 0 && index < this.fItems.length) {
            this.fText = this.fItems[index];
            this.fSelectionIndex = index;
            success = true;
        }
        if (success && !silent) {
            this.dialogFieldChanged();
        }
        return success;
    }

    public boolean selectItem(String name) {
        int i = 0;
        while (i < this.fItems.length) {
            if (this.fItems[i].equals(name)) {
                return this.selectItem(i);
            }
            ++i;
        }
        return false;
    }

    @Override
    public int getSelectionIndex() {
        return this.fSelectionIndex;
    }

    public void setTextWithoutUpdate(String text) {
        this.fText = text;
        if (this.isOkToUse((Control)this.fComboControl)) {
            this.fComboControl.removeModifyListener(this.fModifyListener);
            this.fComboControl.setText(text);
            this.fComboControl.addModifyListener(this.fModifyListener);
        }
    }

    @Override
    public void refresh() {
        super.refresh();
        this.setTextWithoutUpdate(this.fText);
    }

    @Override
    public Control getComboControl() {
        Combo control = null;
        if (this.isOkToUse((Control)this.fComboControl)) {
            control = this.fComboControl;
        }
        return control;
    }
}

