/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.tools.launch.rwt.internal.delegate;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.rap.tools.launch.rwt.internal.util.DebugUtil;

class LaunchTerminator {
    private final ILaunch launch;
    private final Object signal;
    private volatile boolean terminated;

    private LaunchTerminator(ILaunch launch) {
        this.launch = launch;
        this.signal = new Object();
    }

    static void terminatePrevious(ILaunch launch, IProgressMonitor monitor) throws CoreException {
        String taskName = "Terminating previous launch";
        monitor.beginTask(taskName, -1);
        try {
            ILaunch runningLaunch = LaunchTerminator.findRunning(launch);
            if (runningLaunch != null) {
                new LaunchTerminator(runningLaunch).terminate();
            }
        }
        finally {
            monitor.done();
        }
    }

    private static ILaunch findRunning(ILaunch launch) {
        ILaunchConfiguration config = launch.getLaunchConfiguration();
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunch[] runningLaunches = launchManager.getLaunches();
        ILaunch result = null;
        int i = 0;
        while (result == null && i < runningLaunches.length) {
            ILaunch runningLaunch = runningLaunches[i];
            if (runningLaunch != launch && config.getName().equals(DebugUtil.getLaunchName(runningLaunch)) && !runningLaunch.isTerminated()) {
                result = runningLaunches[i];
            }
            ++i;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void terminate() throws DebugException {
        Object object = this.signal;
        synchronized (object) {
            this.terminated = false;
        }
        DebugPlugin debugPlugin = DebugPlugin.getDefault();
        debugPlugin.addDebugEventListener(new IDebugEventSetListener(){

            public void handleDebugEvents(DebugEvent[] events) {
                if (DebugUtil.containsTerminateEventFor(events, LaunchTerminator.this.launch)) {
                    DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
                    LaunchTerminator.this.signalTerminated();
                }
            }
        });
        this.launch.terminate();
        this.waitUntilTerminated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitUntilTerminated() {
        try {
            Object object = this.signal;
            synchronized (object) {
                if (!this.terminated) {
                    this.signal.wait();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.interrupted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void signalTerminated() {
        Object object = this.signal;
        synchronized (object) {
            this.terminated = true;
            this.signal.notifyAll();
        }
    }
}

