/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.tools.launch.rwt.internal.config;

import org.eclipse.rap.tools.launch.rwt.internal.config.RWTLaunchConfig;
import org.eclipse.rap.tools.launch.rwt.internal.config.ValidationResult;
import org.eclipse.rap.tools.launch.rwt.internal.config.Validator;

class ServletPathValidator
extends Validator {
    static final int ERR_SERVLET_PATH_EMPTY = 8030;
    static final int ERR_SERVLET_PATH_INVALID = 8031;
    static final int ERR_SERVLET_PATH_LEADING_SLASH = 8032;

    ServletPathValidator(RWTLaunchConfig config, ValidationResult validationResult) {
        super(config, validationResult);
    }

    void validate() {
        if (this.config.getOpenBrowser()) {
            this.validateNotEmpty();
            this.validateLeadingSlash();
            this.vaidateCharacters();
        }
    }

    private void validateNotEmpty() {
        if (this.config.getServletPath().length() == 0) {
            this.addError("The servlet path must not be empty.", 8030);
        }
    }

    private void validateLeadingSlash() {
        if (!this.config.getServletPath().startsWith("/")) {
            this.addError("The servlet path must start with a slash.", 8032);
        }
    }

    private void vaidateCharacters() {
        String servletPath = this.config.getServletPath();
        if (servletPath.startsWith("/")) {
            servletPath = servletPath.substring(1);
        }
        if (ServletPathValidator.containsChars(servletPath, new char[]{'*', '?', '/', '\\'})) {
            this.addError("The servlet path contains invalid characters.", 8031);
        }
    }

    private static boolean containsChars(String string, char[] chars) {
        boolean hasInvalidChar = false;
        String pattern = new String(chars);
        int i = 0;
        while (!hasInvalidChar && i < string.length()) {
            if (pattern.indexOf(string.charAt(i)) != -1) {
                hasInvalidChar = true;
            }
            ++i;
        }
        return hasInvalidChar;
    }
}

