/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.tools.intro.internal.target;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.URL;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.rap.tools.intro.internal.IntroPlugin;
import org.eclipse.rap.tools.intro.internal.target.IntroMessages;
import org.osgi.framework.Version;

public final class TargetProvider {
    public static final String TARGET_FILE_NAME = "rap-" + TargetProvider.getVersion() + ".target";
    public static final String TARGET_REPOSITORY = "http://download.eclipse.org/rt/rap/targets/" + TARGET_FILE_NAME;

    public static String createLocalTargetDefinition(String targetDefinitionURI, IProgressMonitor monitor) throws IOException {
        monitor.subTask(IntroMessages.TargetProvider_Creating_Definition);
        File targetDefinitionFile = TargetProvider.createLocalTargetDefinitionFile(targetDefinitionURI, TARGET_FILE_NAME);
        return targetDefinitionFile.toURI().toString();
    }

    public static String getVersion() {
        Version version = IntroPlugin.getDefault().getBundle().getVersion();
        return String.valueOf(version.getMajor()) + "." + version.getMinor();
    }

    private static File createLocalTargetDefinitionFile(String targetDefinitionURI, String targetFileName) throws IOException {
        File file = TargetProvider.getLocalTargetDefinitionFile(targetFileName);
        TargetProvider.copyRemoteToLocal(targetDefinitionURI, file);
        return file;
    }

    private static File getLocalTargetDefinitionFile(String targetFileName) throws IOException {
        String stateLocationPath = IntroPlugin.getDefault().getStateLocation().toOSString();
        File file = new Path(stateLocationPath).append(targetFileName).toFile();
        TargetProvider.cleanOldFile(file);
        file.createNewFile();
        return file;
    }

    private static void cleanOldFile(File file) {
        if (file.exists()) {
            file.delete();
        }
    }

    private static void copyRemoteToLocal(String targetDefinitionURI, File file) throws FileNotFoundException, IOException {
        FileOutputStream stream = null;
        OutputStreamWriter writer = null;
        try {
            stream = new FileOutputStream(file);
            writer = new OutputStreamWriter(stream);
            writer.write(TargetProvider.loadRemoteContent(targetDefinitionURI));
            writer.flush();
        }
        finally {
            if (writer != null) {
                writer.close();
            }
            if (stream != null) {
                stream.close();
            }
        }
    }

    private static String loadRemoteContent(String targetDefinitionURI) throws IOException {
        StringBuilder result = new StringBuilder();
        URL uri = new URL(targetDefinitionURI);
        InputStreamReader is = new InputStreamReader(uri.openStream());
        BufferedReader bufferedReader = new BufferedReader(is);
        try {
            String line = bufferedReader.readLine();
            while (line != null) {
                result.append(line);
                line = bufferedReader.readLine();
            }
        }
        finally {
            bufferedReader.close();
        }
        return result.toString();
    }
}

