/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.tools.launch.rwt.internal.delegate;

import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.rap.tools.launch.rwt.internal.config.BrowserMode;
import org.eclipse.rap.tools.launch.rwt.internal.config.RWTLaunchConfig;
import org.eclipse.rap.tools.launch.rwt.internal.delegate.RWTLaunch;
import org.eclipse.rap.tools.launch.rwt.internal.util.DebugUtil;
import org.eclipse.rap.tools.launch.rwt.internal.util.StringUtil;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.statushandlers.StatusManager;

class BrowserOpener {
    private static final int CONNECT_TIMEOUT = 20000;
    private final ILaunch launch;
    private final RWTLaunchConfig launchConfig;
    private final URL url;

    BrowserOpener(ILaunch launch) {
        this.launch = launch;
        this.launchConfig = new RWTLaunchConfig(launch.getLaunchConfiguration());
        this.url = BrowserOpener.toURL(this.computeBrowserUrl());
    }

    void scheduleOpen() {
        DebugPlugin.getDefault().addDebugEventListener(new IDebugEventSetListener(){

            public void handleDebugEvents(DebugEvent[] events) {
                if (DebugUtil.containsCreateEventFor(events, BrowserOpener.this.launch)) {
                    DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
                    BrowserOpener.this.scheduleOpenJob();
                } else if (DebugUtil.containsTerminateEventFor(events, BrowserOpener.this.launch)) {
                    DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
                }
            }
        });
    }

    String computeBrowserUrl() {
        String result;
        int port = new RWTLaunch(this.launch).getPort();
        String contextPath = this.getContextPath();
        String servletPath = this.launchConfig.getServletPath();
        if (port == -1) {
            String pattern = "http://127.0.0.1{1}{2}";
            result = MessageFormat.format(pattern, contextPath, servletPath);
        } else {
            String pattern = "http://127.0.0.1:{0}{1}{2}";
            result = MessageFormat.format(pattern, String.valueOf(port), contextPath, servletPath);
        }
        return result;
    }

    private String getContextPath() {
        String contextPath = "";
        if (this.launchConfig.getUseManualContextPath()) {
            contextPath = this.launchConfig.getContextPath();
        }
        return StringUtil.stripTrailingSlash(contextPath);
    }

    private void scheduleOpenJob() {
        Job job = new Job("Starting client application"){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask("Starting client application", -1);
                try {
                    BrowserOpener.this.waitForServletEngine(monitor);
                    BrowserOpener.this.open(monitor);
                }
                finally {
                    monitor.done();
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    private void open(IProgressMonitor monitor) {
        SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 1);
        String taskName = "Starting client application";
        subMonitor.beginTask(taskName, -1);
        try {
            this.openUrl();
        }
        finally {
            subMonitor.done();
        }
    }

    private void openUrl() {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                if (!BrowserOpener.this.launch.isTerminated()) {
                    try {
                        IWebBrowser browser = BrowserOpener.this.getBrowser();
                        browser.openURL(BrowserOpener.this.url);
                    }
                    catch (CoreException ce) {
                        BrowserOpener.handleCoreException(ce);
                    }
                }
            }
        });
    }

    IWebBrowser getBrowser() throws CoreException {
        int style = 14;
        style = BrowserMode.EXTERNAL.equals(this.launchConfig.getBrowserMode()) ? (style |= 0x80) : (style |= 0x20);
        String id = String.valueOf(this.launchConfig.getName()) + this.launchConfig.getBrowserMode();
        String name = this.launchConfig.getName();
        String toolTip = this.launchConfig.getName();
        IWorkbenchBrowserSupport support = PlatformUI.getWorkbench().getBrowserSupport();
        return support.createBrowser(style, id, name, toolTip);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void waitForServletEngine(IProgressMonitor monitor) {
        SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 1);
        String taskName = "Waiting for servlet engine";
        subMonitor.beginTask(taskName, -1);
        try {
            block9: {
                boolean isReady;
                long start;
                block8: {
                    start = System.currentTimeMillis();
                    isReady = false;
                    if (!true) break block8;
                    if (System.currentTimeMillis() - start > 20000L) return;
                    if (isReady) return;
                    if (Thread.interrupted()) return;
                    if (monitor.isCanceled()) return;
                    if (this.launch.isTerminated()) break block9;
                }
                do {
                    if (!(isReady = this.canConnectToUrl())) {
                        try {
                            Thread.sleep(200L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    if (System.currentTimeMillis() - start > 20000L) return;
                    if (isReady) return;
                    if (Thread.interrupted()) return;
                    if (monitor.isCanceled()) return;
                } while (!this.launch.isTerminated());
            }
            return;
        }
        finally {
            subMonitor.done();
        }
    }

    boolean canConnectToUrl() {
        boolean result = false;
        try {
            Socket socket = new Socket(this.url.getHost(), this.url.getPort());
            socket.close();
            result = true;
        }
        catch (Exception exception) {}
        return result;
    }

    private static void handleCoreException(CoreException coreException) {
        IStatus status = coreException.getStatus();
        StatusManager.getManager().handle(status, 2);
    }

    private static URL toURL(String urlString) {
        try {
            return new URL(urlString);
        }
        catch (MalformedURLException e) {
            String msg = "Failed to create URL from string: " + urlString;
            throw new RuntimeException(msg, e);
        }
    }
}

