/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.addons.chart.demo;

import org.eclipse.rap.addons.chart.Colors;
import org.eclipse.rap.addons.chart.basic.DataGroup;
import org.eclipse.rap.addons.chart.basic.DataItem;
import org.eclipse.rap.addons.chart.basic.LineChart;
import org.eclipse.rap.rwt.application.AbstractEntryPoint;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class LineChartSnippet
extends AbstractEntryPoint {
    private LineChart lineChart;

    public void createContents(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        this.createLineChart(parent);
        this.createUpdateButton(parent);
        this.update();
    }

    private void createLineChart(Composite parent) {
        this.lineChart = new LineChart(parent, 0);
        this.lineChart.setLayoutData((Object)new GridData(4, 4, true, true));
        this.lineChart.setXAxisLabel("Time");
        this.lineChart.setYAxisLabel("Radiation");
        this.lineChart.setYAxisFormat("d");
        this.lineChart.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                System.out.println("Selected line item #" + event.index + ", point #" + event.detail);
            }
        });
    }

    private void createUpdateButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("Change data");
        button.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                LineChartSnippet.this.update();
            }
        });
    }

    private void update() {
        this.lineChart.setItems(LineChartSnippet.createItems());
    }

    private static DataGroup[] createItems() {
        return new DataGroup[]{new DataGroup(LineChartSnippet.createRandomPoints(), "Series 1", Colors.CATEGORY_10[0]), new DataGroup(LineChartSnippet.createRandomPoints(), "Series 2", Colors.CATEGORY_10[1])};
    }

    private static DataItem[] createRandomPoints() {
        DataItem[] values = new DataItem[100];
        int i = 0;
        while (i < values.length) {
            values[i] = new DataItem(Math.random() * 100.0);
            ++i;
        }
        return values;
    }
}

