/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.renderers.swt;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.e4.ui.model.application.ui.MGenericTile;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Shell;

public class SashLayout
extends Layout {
    int minSashPercent = 10;
    int marginLeft = 0;
    int marginRight = 0;
    int marginTop = 0;
    int marginBottom = 0;
    int sashWidth = 4;
    MUIElement root;
    private Composite host;
    List<SashRect> sashes = new ArrayList<SashRect>();
    boolean draggingSashes = false;
    List<SashRect> sashesToDrag;
    public boolean layoutUpdateInProgress = false;
    List<Sash> sashWidgets = new ArrayList<Sash>();

    public SashLayout(Composite host, MUIElement root) {
        this.root = root;
        this.host = host;
    }

    protected void layout(Composite composite, boolean flushCache) {
        if (this.root == null) {
            return;
        }
        Rectangle bounds = composite.getBounds();
        if (composite instanceof Shell) {
            bounds = ((Shell)composite).getClientArea();
        } else {
            bounds.x = 0;
            bounds.y = 0;
        }
        bounds.width -= this.marginLeft + this.marginRight;
        bounds.height -= this.marginTop + this.marginBottom;
        bounds.x += this.marginLeft;
        bounds.y += this.marginTop;
        this.sashes.clear();
        this.tileSubNodes(bounds, this.root);
        this.updateSashWidgets();
    }

    private void updateSashWidgets() {
        int i = 0;
        while (i < this.sashes.size()) {
            SashRect sashRect = this.sashes.get(i);
            if (i < this.sashWidgets.size()) {
                Sash sashWidget = this.sashWidgets.get(i);
                if (this.isSameOrientation(sashWidget, sashRect)) {
                    sashWidget.setBounds(sashRect.rect);
                } else {
                    this.sashWidgets.set(i, this.createSash(sashRect)).dispose();
                }
            } else {
                this.sashWidgets.add(this.createSash(sashRect));
            }
            ++i;
        }
        while (this.sashWidgets.size() > this.sashes.size()) {
            this.sashWidgets.remove(this.sashWidgets.size() - 1).dispose();
        }
    }

    private Sash createSash(final SashRect sashRect) {
        boolean horizontal = !sashRect.container.isHorizontal();
        Sash sash = new Sash(this.host, horizontal ? 256 : 512);
        sash.setBounds(sashRect.rect);
        sash.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Display display = SashLayout.this.host.getDisplay();
                Point cursorLocation = display.getCursorLocation();
                Point mapped = display.map(null, (Control)SashLayout.this.host, cursorLocation);
                SashLayout.this.sashesToDrag = new ArrayList<SashRect>();
                SashLayout.this.sashesToDrag.add(sashRect);
                SashLayout.this.adjustWeights(SashLayout.this.sashesToDrag, mapped.x, mapped.y);
                SashLayout.this.host.layout();
                SashLayout.this.host.update();
            }
        });
        return sash;
    }

    private boolean isSameOrientation(Sash sash, SashRect sashRect) {
        boolean isSashHorizontal = (sash.getStyle() & 0x100) != 0;
        boolean isSashContainerHorizontal = sashRect.container.isHorizontal();
        return isSashHorizontal ^ isSashContainerHorizontal;
    }

    protected void adjustWeights(List<SashRect> sashes, int curX, int curY) {
        for (SashRect sr : sashes) {
            int rightWeight;
            int leftWeight;
            double pct;
            int totalWeight = SashLayout.getWeight(sr.left) + SashLayout.getWeight(sr.right);
            int minSashValue = (int)((double)totalWeight / 100.0 * (double)this.minSashPercent + 0.5);
            Rectangle leftRect = this.getRectangle(sr.left);
            Rectangle rightRect = this.getRectangle(sr.right);
            if (leftRect == null || rightRect == null) continue;
            if (sr.container.isHorizontal()) {
                double left = leftRect.x;
                double right = rightRect.x + rightRect.width;
                pct = ((double)curX - left) / (right - left);
                leftWeight = (int)((double)totalWeight * pct + 0.5);
                if (leftWeight < minSashValue) {
                    leftWeight = minSashValue;
                }
                if (leftWeight > totalWeight - minSashValue) {
                    leftWeight = totalWeight - minSashValue;
                }
                rightWeight = totalWeight - leftWeight;
            } else {
                double top = leftRect.y;
                double bottom = rightRect.y + rightRect.height;
                pct = ((double)curY - top) / (bottom - top);
                leftWeight = (int)((double)totalWeight * pct + 0.5);
                if (leftWeight < minSashValue) {
                    leftWeight = minSashValue;
                }
                if (leftWeight > totalWeight - minSashValue) {
                    leftWeight = totalWeight - minSashValue;
                }
                rightWeight = totalWeight - leftWeight;
            }
            this.setWeight(sr.left, leftWeight);
            this.setWeight(sr.right, rightWeight);
        }
    }

    private void setWeight(MUIElement element, int weight) {
        element.setContainerData(Integer.toString(weight));
    }

    private Rectangle getRectangle(MUIElement element) {
        if (element.getWidget() instanceof Rectangle) {
            return (Rectangle)element.getWidget();
        }
        if (element.getWidget() instanceof Control) {
            return ((Control)element.getWidget()).getBounds();
        }
        return null;
    }

    protected List<SashRect> getSashRects(int x, int y) {
        ArrayList<SashRect> srs = new ArrayList<SashRect>();
        Rectangle target = new Rectangle(x - 5, y - 5, 10, 10);
        for (SashRect sr : this.sashes) {
            if (sr.container.getTags().contains("NoMove") || !sr.rect.intersects(target)) continue;
            srs.add(sr);
        }
        return srs;
    }

    protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
        return new Point(600, 400);
    }

    private int totalWeight(MGenericTile<?> node) {
        int total = 0;
        for (MUIElement subNode : node.getChildren()) {
            if (!subNode.isToBeRendered() || !subNode.isVisible()) continue;
            total += SashLayout.getWeight(subNode);
        }
        return total;
    }

    private void tileSubNodes(Rectangle bounds, MUIElement node) {
        if (node != this.root) {
            this.setRectangle(node, bounds);
        }
        if (!(node instanceof MGenericTile)) {
            return;
        }
        MGenericTile sashContainer = (MGenericTile)node;
        List<MUIElement> visibleChildren = this.getVisibleChildren(sashContainer);
        int childCount = visibleChildren.size();
        int availableWidth = sashContainer.isHorizontal() ? bounds.width : bounds.height;
        availableWidth -= (childCount - 1) * this.sashWidth;
        double totalWeight = this.totalWeight(sashContainer);
        int tilePos = sashContainer.isHorizontal() ? bounds.x : bounds.y;
        MUIElement prev = null;
        for (MUIElement subNode : visibleChildren) {
            if (prev != null) {
                Rectangle sashRect = sashContainer.isHorizontal() ? new Rectangle(tilePos, bounds.y, this.sashWidth, bounds.height) : new Rectangle(bounds.x, tilePos, bounds.width, this.sashWidth);
                this.sashes.add(new SashRect(sashRect, sashContainer, prev, subNode));
                this.host.redraw(sashRect.x, sashRect.y, sashRect.width, sashRect.height, false);
                tilePos += this.sashWidth;
            }
            double ratio = (double)SashLayout.getWeight(subNode) / totalWeight;
            int newSize = (int)((double)availableWidth * ratio + 0.5);
            Rectangle subBounds = sashContainer.isHorizontal() ? new Rectangle(tilePos, bounds.y, newSize, bounds.height) : new Rectangle(bounds.x, tilePos, bounds.width, newSize);
            tilePos += newSize;
            this.tileSubNodes(subBounds, subNode);
            prev = subNode;
        }
    }

    private void setRectangle(MUIElement node, Rectangle bounds) {
        if (node.getWidget() instanceof Control) {
            Control ctrl = (Control)node.getWidget();
            ctrl.setBounds(bounds);
        } else if (node.getWidget() instanceof Rectangle) {
            Rectangle theRect = (Rectangle)node.getWidget();
            theRect.x = bounds.x;
            theRect.y = bounds.y;
            theRect.width = bounds.width;
            theRect.height = bounds.height;
        }
    }

    private List<MUIElement> getVisibleChildren(MGenericTile<?> sashContainer) {
        ArrayList<MUIElement> visKids = new ArrayList<MUIElement>();
        for (MUIElement child : sashContainer.getChildren()) {
            if (!child.isToBeRendered() || !child.isVisible()) continue;
            visKids.add(child);
        }
        return visKids;
    }

    private static int getWeight(MUIElement element) {
        String info = element.getContainerData();
        if (info == null || info.length() == 0) {
            return 0;
        }
        try {
            int value = Integer.parseInt(info);
            return value;
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    class SashRect {
        Rectangle rect;
        MGenericTile<?> container;
        MUIElement left;
        MUIElement right;

        public SashRect(Rectangle rect, MGenericTile<?> container, MUIElement left, MUIElement right) {
            this.container = container;
            this.rect = rect;
            this.left = left;
            this.right = right;
        }
    }
}

