/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.rap.rwt.internal.textsize.TextSizeUtil;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GCDelegate;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

class DeviceGC
extends GCDelegate {
    private final Device device;
    private Color background;
    private Color foreground;
    private Font font;
    private int alpha;
    private int lineWidth;
    private int lineCap;
    private int lineJoin;

    DeviceGC(Device device) {
        this.device = device;
        this.background = device.getSystemColor(1);
        this.foreground = device.getSystemColor(2);
        this.font = device.getSystemFont();
        this.alpha = 255;
        this.lineWidth = 0;
        this.lineCap = 1;
        this.lineJoin = 1;
    }

    void setBackground(Color color) {
        this.background = color;
    }

    Color getBackground() {
        return this.background;
    }

    void setForeground(Color color) {
        this.foreground = color;
    }

    Color getForeground() {
        return this.foreground;
    }

    void setFont(Font font) {
        this.font = font;
    }

    Font getFont() {
        return this.font;
    }

    Font getDefaultFont() {
        return this.device.getSystemFont();
    }

    void setAlpha(int alpha) {
        this.alpha = alpha;
    }

    int getAlpha() {
        return this.alpha;
    }

    void setLineWidth(int lineWidth) {
        this.lineWidth = lineWidth;
    }

    int getLineWidth() {
        return this.lineWidth;
    }

    void setLineCap(int lineCap) {
        this.lineCap = lineCap;
    }

    int getLineCap() {
        return this.lineCap;
    }

    void setLineJoin(int lineJoin) {
        this.lineJoin = lineJoin;
    }

    int getLineJoin() {
        return this.lineJoin;
    }

    Rectangle getClipping() {
        return this.device.getBounds();
    }

    Point stringExtent(String string) {
        return TextSizeUtil.stringExtent(this.font, string);
    }

    Point textExtent(String string, int wrapWidth) {
        return TextSizeUtil.textExtent(this.font, string, wrapWidth);
    }

    void drawPoint(int x, int y) {
    }

    void drawLine(int x1, int y1, int x2, int y2) {
    }

    void drawPolyline(int[] pointArray, boolean close, boolean fill) {
    }

    void drawRectangle(Rectangle bounds, boolean fill) {
    }

    void drawRoundRectangle(Rectangle bounds, int arcWidth, int arcHeight, boolean fill) {
    }

    void fillGradientRectangle(Rectangle bounds, boolean vertical) {
    }

    void drawArc(Rectangle boundsx, int startAngle, int arcAngle, boolean fill) {
    }

    void drawImage(Image image, Rectangle src, Rectangle dest, boolean simple) {
    }

    void drawText(String string, int x, int y, int flags) {
    }

    void drawPath(Path path, boolean fill) {
    }
}

