/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.autoedit;

import com.google.inject.Inject;
import com.google.inject.Provider;
import org.eclipse.jface.text.DefaultIndentLineAutoEditStrategy;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.xtext.ui.editor.autoedit.AbstractEditStrategyProvider;
import org.eclipse.xtext.ui.editor.autoedit.CompoundMultiLineTerminalsEditStrategy;
import org.eclipse.xtext.ui.editor.autoedit.MultiLineTerminalsEditStrategy;
import org.eclipse.xtext.ui.editor.autoedit.PartitionDeletionEditStrategy;
import org.eclipse.xtext.ui.editor.autoedit.PartitionEndSkippingEditStrategy;
import org.eclipse.xtext.ui.editor.autoedit.PartitionInsertEditStrategy;
import org.eclipse.xtext.ui.editor.autoedit.SingleLineTerminalsStrategy;

public class DefaultAutoEditStrategyProvider
extends AbstractEditStrategyProvider {
    @Inject
    protected Provider<DefaultIndentLineAutoEditStrategy> defaultIndentLineAutoEditStrategy;
    @Inject
    protected Provider<PartitionEndSkippingEditStrategy> partitionEndSkippingEditStrategy;
    @Inject
    protected PartitionInsertEditStrategy.Factory partitionInsert;
    @Inject
    protected PartitionDeletionEditStrategy.Factory partitionDeletion;
    @Inject
    protected SingleLineTerminalsStrategy.Factory singleLineTerminals;
    @Inject
    protected MultiLineTerminalsEditStrategy.Factory multiLineTerminals;
    @Inject
    protected CompoundMultiLineTerminalsEditStrategy.Factory compoundMultiLineTerminals;

    @Override
    protected void configure(AbstractEditStrategyProvider.IEditStrategyAcceptor acceptor) {
        this.configureIndentationEditStrategy(acceptor);
        this.configureStringLiteral(acceptor);
        this.configureParenthesis(acceptor);
        this.configureSquareBrackets(acceptor);
        this.configureCurlyBracesBlock(acceptor);
        this.configureMultilineComments(acceptor);
        this.configureCompoundBracesBlocks(acceptor);
    }

    protected void configureCompoundBracesBlocks(AbstractEditStrategyProvider.IEditStrategyAcceptor acceptor) {
        acceptor.accept(this.compoundMultiLineTerminals.newInstanceFor("{", "}").and("[", "]").and("(", ")"), "__dftl_partition_content_type");
    }

    protected void configureIndentationEditStrategy(AbstractEditStrategyProvider.IEditStrategyAcceptor acceptor) {
        acceptor.accept((IAutoEditStrategy)this.defaultIndentLineAutoEditStrategy.get(), "__dftl_partition_content_type");
        acceptor.accept((IAutoEditStrategy)this.defaultIndentLineAutoEditStrategy.get(), "__comment");
        acceptor.accept((IAutoEditStrategy)this.defaultIndentLineAutoEditStrategy.get(), "__sl_comment");
    }

    protected void configureMultilineComments(AbstractEditStrategyProvider.IEditStrategyAcceptor acceptor) {
        acceptor.accept(this.singleLineTerminals.newInstance("/*", " */"), "__dftl_partition_content_type");
        acceptor.accept(this.multiLineTerminals.newInstance("/***", " * ", " ***/"), "__dftl_partition_content_type");
        acceptor.accept(this.multiLineTerminals.newInstance("/***", " * ", " ***/"), "__comment");
        acceptor.accept(this.multiLineTerminals.newInstance("/*", " * ", " */"), "__dftl_partition_content_type");
        acceptor.accept(this.multiLineTerminals.newInstance("/*", " * ", " */"), "__comment");
    }

    protected void configureCurlyBracesBlock(AbstractEditStrategyProvider.IEditStrategyAcceptor acceptor) {
        acceptor.accept(this.singleLineTerminals.newInstance("{", "}"), "__dftl_partition_content_type");
    }

    protected void configureSquareBrackets(AbstractEditStrategyProvider.IEditStrategyAcceptor acceptor) {
        acceptor.accept(this.singleLineTerminals.newInstance("[", "]"), "__dftl_partition_content_type");
    }

    protected void configureParenthesis(AbstractEditStrategyProvider.IEditStrategyAcceptor acceptor) {
        acceptor.accept(this.singleLineTerminals.newInstance("(", ")"), "__dftl_partition_content_type");
    }

    protected void configureStringLiteral(AbstractEditStrategyProvider.IEditStrategyAcceptor acceptor) {
        acceptor.accept(this.partitionInsert.newInstance("\"", "\""), "__dftl_partition_content_type");
        acceptor.accept(this.partitionInsert.newInstance("'", "'"), "__dftl_partition_content_type");
        acceptor.accept(this.partitionDeletion.newInstance("\"", "\""), "__dftl_partition_content_type");
        acceptor.accept(this.partitionDeletion.newInstance("'", "'"), "__dftl_partition_content_type");
        acceptor.accept((IAutoEditStrategy)this.partitionEndSkippingEditStrategy.get(), "__string");
    }
}

