/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.java.resource;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.Map;
import org.eclipse.xtext.xbase.lib.Exceptions;

public class InMemoryClassLoader
extends ClassLoader {
    private Map<String, byte[]> classMap;

    public InMemoryClassLoader(Map<String, byte[]> classMap, ClassLoader parent) {
        super(parent);
        this.classMap = classMap;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        byte[] bytes = this.classMap.get(name);
        if (bytes == null) {
            return super.findClass(name);
        }
        return this.defineClass(name, bytes, 0, bytes.length);
    }

    @Override
    protected URL findResource(String path) {
        try {
            String className;
            byte[] bytes;
            boolean _endsWith = path.endsWith(".class");
            if (_endsWith && (bytes = this.classMap.get(className = this.pathToClassName(path))) != null) {
                URLStreamHandler _function = new URLStreamHandler(){

                    @Override
                    protected URLConnection openConnection(URL it) throws IOException {
                        return new URLConnection(it){

                            @Override
                            public void connect() {
                            }

                            @Override
                            public InputStream getInputStream() {
                                return new ByteArrayInputStream(bytes);
                            }
                        };
                    }
                };
                return new URL("in-memory", null, -1, path, _function);
            }
            return super.findResource(path);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected String pathToClassName(String path) {
        boolean _endsWith = path.endsWith(".class");
        if (_endsWith) {
            int _length = path.length();
            int _minus = _length - 6;
            return path.substring(0, _minus).replace("/", ".");
        }
        return null;
    }
}

