/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.databinding.ui.editor.contentproviders;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.Array;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.ClassUtils;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.databinding.Messages;
import org.eclipse.wb.internal.core.databinding.ui.UiUtils;
import org.eclipse.wb.internal.core.databinding.ui.editor.DialogFieldUiContentProvider;
import org.eclipse.wb.internal.core.databinding.ui.editor.contentproviders.ChooseClassConfiguration;
import org.eclipse.wb.internal.core.databinding.ui.editor.contentproviders.ChooseClassRouter;
import org.eclipse.wb.internal.core.databinding.ui.editor.dialogfields.ComboButtonsDialogField;
import org.eclipse.wb.internal.core.utils.dialogfields.DialogField;
import org.eclipse.wb.internal.core.utils.dialogfields.IDialogFieldListener;
import org.eclipse.wb.internal.core.utils.dialogfields.IStringButtonAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ChooseClassUiContentProvider
extends DialogFieldUiContentProvider {
    private static final Map<String, List<String>> SCOPES = Maps.newHashMap();
    private final List<String> m_classes;
    private final ChooseClassConfiguration m_configuration;
    private final ComboButtonsDialogField m_dialogField;
    private boolean m_checkClasses = true;
    private ChooseClassRouter m_router;
    private final IDialogFieldListener m_fieldChangeListener = new IDialogFieldListener(){

        public void dialogFieldChanged(DialogField field) {
            ChooseClassUiContentProvider.this.calculateFinish();
        }
    };
    private final IStringButtonAdapter m_browseAdapter = new IStringButtonAdapter(){

        public void changeControlPressed(DialogField field) {
            ChooseClassUiContentProvider.this.handleChooseBrowse();
        }
    };
    private final IStringButtonAdapter m_clearAdapter = new IStringButtonAdapter(){

        public void changeControlPressed(DialogField field) {
            ChooseClassUiContentProvider.this.m_dialogField.selectItem(ChooseClassUiContentProvider.this.m_configuration.getClearValue());
        }
    };

    public ChooseClassUiContentProvider(ChooseClassConfiguration configuration) {
        Object[] defaultValues;
        this.m_configuration = configuration;
        String valuesScope = this.m_configuration.getValuesScope();
        if (valuesScope == null) {
            this.m_classes = Lists.newArrayList();
        } else {
            ArrayList classes = SCOPES.get(valuesScope);
            if (classes == null) {
                classes = Lists.newArrayList();
                SCOPES.put(valuesScope, classes);
            }
            this.m_classes = classes;
        }
        this.m_dialogField = new ComboButtonsDialogField(this.m_browseAdapter, this.m_clearAdapter, 2056, this.m_configuration.isUseClearButton());
        String dialogFieldLabel = this.m_configuration.getDialogFieldLabel();
        if (dialogFieldLabel != null) {
            this.m_dialogField.setLabelText(dialogFieldLabel);
        }
        this.m_dialogField.setEnabled(this.m_configuration.isDialogFieldEnabled());
        if (this.m_configuration.isUseClearButton()) {
            this.addClassToCombo(this.m_configuration.getClearValue());
        }
        if (!ArrayUtils.isEmpty((Object[])(defaultValues = this.m_configuration.getDefaultValues()))) {
            int i = 0;
            while (i < defaultValues.length) {
                this.addClassToCombo((String)defaultValues[i]);
                ++i;
            }
        }
        this.m_dialogField.addItems(this.m_classes);
        this.m_dialogField.setDialogFieldListener(this.m_fieldChangeListener);
    }

    final void setRouter(ChooseClassRouter router) {
        this.m_router = router;
    }

    public final ChooseClassConfiguration getConfiguration() {
        return this.m_configuration;
    }

    @Override
    public DialogField getDialogField() {
        return this.m_dialogField;
    }

    private void handleChooseBrowse() {
        try {
            String className = UiUtils.chooseType(this.getShell(), this.getJavaProject(), this.m_configuration.getBaseClassNames(), this.m_configuration.getOpenTypeStyle());
            if (className != null) {
                this.setClassName(className);
            }
        }
        catch (Throwable e) {
            DesignerPlugin.log((Throwable)e);
        }
    }

    protected void calculateFinish() {
        String className = this.getClassName();
        if (this.m_router != null) {
            this.m_router.handle();
        }
        if (className.length() == 0) {
            this.setErrorMessage(this.m_configuration.getEmptyClassErrorMessage());
        } else {
            boolean noConstructor;
            String errorMessagePrefix;
            Class<?>[][] constructorsParameters;
            block26: {
                if (this.m_configuration.isDefaultString(className) || className.equals(this.m_configuration.getClearValue()) || ArrayUtils.indexOf((Object[])this.m_configuration.getDefaultValues(), (Object)className) != -1) {
                    this.setErrorMessage(null);
                    return;
                }
                constructorsParameters = this.m_configuration.getConstructorsParameters();
                errorMessagePrefix = this.m_configuration.getErrorMessagePrefix();
                noConstructor = false;
                try {
                    int i;
                    Class<?> testClass = this.loadClass(className);
                    int modifiers = testClass.getModifiers();
                    if (!Modifier.isPublic(modifiers)) {
                        this.setErrorMessage(String.valueOf(errorMessagePrefix) + Messages.ChooseClassUiContentProvider_validateNotPublic);
                        return;
                    }
                    if (!this.m_configuration.isChooseInterfaces() && Modifier.isAbstract(modifiers)) {
                        this.setErrorMessage(String.valueOf(errorMessagePrefix) + Messages.ChooseClassUiContentProvider_validateAbstract);
                        return;
                    }
                    if (this.m_checkClasses) {
                        this.m_checkClasses = false;
                        if (constructorsParameters != null) {
                            i = 0;
                            while (i < constructorsParameters.length) {
                                Class<?>[] constructorParameters = constructorsParameters[i];
                                int j = 0;
                                while (j < constructorParameters.length) {
                                    String parameterClassName;
                                    Class<?> constructorParameterClass = constructorParameters[j];
                                    if (constructorParameterClass.isArray()) {
                                        parameterClassName = constructorParameterClass.getComponentType().getName();
                                        if (parameterClassName.startsWith("org.eclipse")) {
                                            constructorParameters[j] = Array.newInstance(this.loadClass(parameterClassName), new int[1]).getClass();
                                        }
                                    } else {
                                        parameterClassName = constructorParameterClass.getName();
                                        if (parameterClassName.startsWith("org.eclipse")) {
                                            constructorParameters[j] = this.loadClass(parameterClassName);
                                        }
                                    }
                                    ++j;
                                }
                                ++i;
                            }
                        }
                    }
                    if (constructorsParameters == null) break block26;
                    noConstructor = true;
                    i = 0;
                    while (i < constructorsParameters.length) {
                        try {
                            testClass.getConstructor(constructorsParameters[i]);
                            noConstructor = false;
                            break;
                        }
                        catch (SecurityException securityException) {
                        }
                        catch (NoSuchMethodException noSuchMethodException) {}
                        ++i;
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    this.setErrorMessage(String.valueOf(errorMessagePrefix) + Messages.ChooseClassUiContentProvider_validateNotExist);
                    return;
                }
            }
            if (noConstructor) {
                StringBuffer parameters = new StringBuffer(errorMessagePrefix);
                parameters.append(Messages.ChooseClassUiContentProvider_validatePublicConstructor);
                int i = 0;
                while (i < constructorsParameters.length) {
                    Class<?>[] constructorParameters = constructorsParameters[i];
                    if (i > 0) {
                        parameters.append(" ");
                    }
                    parameters.append(ClassUtils.getShortClassName((String)className));
                    parameters.append("(");
                    int j = 0;
                    while (j < constructorParameters.length) {
                        if (j > 0) {
                            parameters.append(", ");
                        }
                        parameters.append(ClassUtils.getShortClassName(constructorParameters[j]));
                        ++j;
                    }
                    parameters.append(")");
                    ++i;
                }
                parameters.append(".");
                this.setErrorMessage(parameters.toString());
            } else {
                this.setErrorMessage(null);
            }
        }
    }

    public void addClassToCombo(String className) {
        if (this.m_classes.indexOf(className) == -1) {
            this.m_dialogField.addItem(className);
        }
    }

    public Class<?> getChoosenClass() throws Exception {
        return this.loadClass(this.getClassName());
    }

    public final String getClassName() {
        return this.m_dialogField.getText();
    }

    protected final void setClearClassName() {
        String className = "";
        int index = this.m_dialogField.getListItems().indexOf(className);
        if (index == -1) {
            this.m_dialogField.setDialogFieldListener(null);
            this.m_dialogField.addItem(className);
            this.m_dialogField.setDialogFieldListener(this.m_fieldChangeListener);
            this.m_dialogField.selectItem(className);
        } else {
            this.m_dialogField.selectItem(index);
        }
    }

    public final void setClassName(String className) {
        if (this.m_configuration.isDefaultString(className = this.m_configuration.getRetargetClassName(className))) {
            int index = this.m_dialogField.getListItems().indexOf(className);
            if (index == -1) {
                this.m_dialogField.setDialogFieldListener(null);
                this.m_dialogField.addItem(className);
                this.m_dialogField.setDialogFieldListener(this.m_fieldChangeListener);
                this.m_dialogField.selectItem(className);
            } else {
                this.m_dialogField.selectItem(index);
            }
            return;
        }
        if (className.equals(this.m_configuration.getClearValue()) || ArrayUtils.indexOf((Object[])this.m_configuration.getDefaultValues(), (Object)className) != -1) {
            this.m_dialogField.selectItem(className);
            return;
        }
        int index = this.m_dialogField.getListItems().indexOf(className);
        if (index == -1) {
            this.m_classes.add(className);
            this.m_dialogField.setDialogFieldListener(null);
            this.m_dialogField.addItem(className);
            this.m_dialogField.setDialogFieldListener(this.m_fieldChangeListener);
            this.m_dialogField.selectItem(className);
        } else {
            this.m_dialogField.selectItem(index);
        }
    }
}

