/**
 * Copyright (c) 2010-2016, Abel Hegedus, IncQuery Labs Ltd.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * Contributors:
 * Abel Hegedus - initial API and implementation
 */
package org.eclipse.viatra.query.tooling.ui.queryresult.properties;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.viatra.query.runtime.api.IPatternMatch;
import org.eclipse.viatra.query.runtime.api.IQuerySpecification;
import org.eclipse.viatra.query.runtime.api.ViatraQueryMatcher;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PParameter;
import org.eclipse.viatra.query.tooling.ui.queryresult.QueryResultTreeMatcher;
import org.eclipse.viatra.query.tooling.ui.queryresult.properties.MatchParameterPropertyDescriptor;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;

/**
 * @author Abel Hegedus
 */
@SuppressWarnings("all")
public class MatcherFiltersPropertySource implements IPropertySource {
  private final QueryResultTreeMatcher matcher;
  
  private final Map<PParameter, IPropertyDescriptor> descriptors = CollectionLiterals.<PParameter, IPropertyDescriptor>newHashMap();
  
  public MatcherFiltersPropertySource(final QueryResultTreeMatcher matcher) {
    this.matcher = matcher;
  }
  
  @Override
  public Object getEditableValue() {
    return this;
  }
  
  @Override
  public String toString() {
    boolean _isFiltered = this.matcher.isFiltered();
    if (_isFiltered) {
      return "Filtered";
    }
    return "No filters specified";
  }
  
  @Override
  public IPropertyDescriptor[] getPropertyDescriptors() {
    final List<IPropertyDescriptor> filters = Lists.<IPropertyDescriptor>newArrayList();
    ViatraQueryMatcher _matcher = this.matcher.getMatcher();
    IQuerySpecification _specification = _matcher.getSpecification();
    List _parameters = _specification.getParameters();
    final List<PParameter> parameters = ((List<PParameter>) _parameters);
    boolean _isEmpty = this.descriptors.isEmpty();
    if (_isEmpty) {
      final Procedure1<PParameter> _function = new Procedure1<PParameter>() {
        @Override
        public void apply(final PParameter it) {
          final MatchParameterPropertyDescriptor property = new MatchParameterPropertyDescriptor(it, MatcherFiltersPropertySource.this.matcher);
          MatcherFiltersPropertySource.this.descriptors.put(it, property);
          filters.add(property);
        }
      };
      IterableExtensions.<PParameter>forEach(parameters, _function);
    } else {
      final Procedure1<PParameter> _function_1 = new Procedure1<PParameter>() {
        @Override
        public void apply(final PParameter it) {
          IPropertyDescriptor _get = MatcherFiltersPropertySource.this.descriptors.get(it);
          filters.add(_get);
        }
      };
      IterableExtensions.<PParameter>forEach(parameters, _function_1);
    }
    IPropertyDescriptor[] _newArrayOfSize = new IPropertyDescriptor[0];
    return filters.<IPropertyDescriptor>toArray(_newArrayOfSize);
  }
  
  @Override
  public Object getPropertyValue(final Object id) {
    final PParameter param = ((PParameter) id);
    IPatternMatch _filterMatch = this.matcher.getFilterMatch();
    String _name = param.getName();
    return _filterMatch.get(_name);
  }
  
  @Override
  public boolean isPropertySet(final Object id) {
    final PParameter param = ((PParameter) id);
    IPatternMatch _filterMatch = this.matcher.getFilterMatch();
    String _name = param.getName();
    Object _get = _filterMatch.get(_name);
    return (!Objects.equal(_get, null));
  }
  
  @Override
  public void resetPropertyValue(final Object id) {
    final PParameter param = ((PParameter) id);
    IPatternMatch _filterMatch = this.matcher.getFilterMatch();
    String _name = param.getName();
    _filterMatch.set(_name, null);
    IPatternMatch _filterMatch_1 = this.matcher.getFilterMatch();
    this.matcher.filterUpdated(_filterMatch_1);
  }
  
  @Override
  public void setPropertyValue(final Object id, final Object value) {
    final PParameter param = ((PParameter) id);
    IPatternMatch _filterMatch = this.matcher.getFilterMatch();
    String _name = param.getName();
    _filterMatch.set(_name, value);
    IPatternMatch _filterMatch_1 = this.matcher.getFilterMatch();
    this.matcher.filterUpdated(_filterMatch_1);
  }
}
