/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.timing.ui.flamegraph;

import com.google.common.collect.Iterables;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Deque;
import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.tracecompass.internal.analysis.timing.core.callgraph.AggregatedCalledFunction;
import org.eclipse.tracecompass.internal.analysis.timing.core.callgraph.ThreadNode;
import org.eclipse.tracecompass.internal.analysis.timing.ui.flamegraph.FlamegraphDepthEntry;
import org.eclipse.tracecompass.internal.analysis.timing.ui.flamegraph.FlamegraphEvent;
import org.eclipse.tracecompass.internal.analysis.timing.ui.flamegraph.SortOption;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.ITimeGraphContentProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeGraphEntry;

public class FlameGraphContentProvider
implements ITimeGraphContentProvider {
    private final List<FlamegraphDepthEntry> fFlameGraphEntries = new ArrayList<FlamegraphDepthEntry>();
    private SortOption fSortOption = SortOption.BY_NAME;
    private @NonNull Comparator<FlamegraphDepthEntry> fThreadComparator = Objects.requireNonNull(Comparator.comparing(TimeGraphEntry::getName));

    private void setData(AggregatedCalledFunction firstNode, List<@NonNull FlamegraphDepthEntry> childrenEntries, Deque<Long> timestampStack) {
        long lastEnd = timestampStack.peek();
        int i = 0;
        while (i < firstNode.getMaxDepth()) {
            if (i >= childrenEntries.size()) {
                FlamegraphDepthEntry entry = new FlamegraphDepthEntry(String.valueOf(i), 0L, firstNode.getDuration(), i, i);
                childrenEntries.add(entry);
            }
            childrenEntries.get(i).updateEndTime(lastEnd + firstNode.getDuration());
            ++i;
        }
        FlamegraphDepthEntry firstEntry = childrenEntries.get(0);
        firstEntry.addEvent((ITimeEvent)new FlamegraphEvent((ITimeGraphEntry)firstEntry, lastEnd, firstNode));
        this.addEvent(firstNode, childrenEntries, timestampStack);
        timestampStack.pop();
    }

    private void addEvent(AggregatedCalledFunction node, List<@NonNull FlamegraphDepthEntry> childrenEntries, Deque<Long> timestampStack) {
        if (node.hasChildren()) {
            ArrayList<AggregatedCalledFunction> children = new ArrayList<AggregatedCalledFunction>(node.getChildren());
            children.sort(Comparator.comparingLong(AggregatedCalledFunction::getDuration));
            for (AggregatedCalledFunction child2 : children) {
                this.addEvent(child2, childrenEntries, timestampStack);
            }
            node.getChildren().forEach(child -> {
                Object e = timestampStack.pop();
            });
        }
        FlamegraphDepthEntry entry = childrenEntries.get(node.getDepth());
        entry.addEvent((ITimeEvent)new FlamegraphEvent((ITimeGraphEntry)entry, timestampStack.peek(), node));
        timestampStack.push(timestampStack.peek() + node.getDuration());
    }

    public boolean hasChildren(Object element) {
        return !this.fFlameGraphEntries.isEmpty();
    }

    public ITimeGraphEntry[] getElements(Object inputElement) {
        this.fFlameGraphEntries.clear();
        if (inputElement instanceof Collection) {
            Collection threadNodes = (Collection)inputElement;
            for (ThreadNode object : Iterables.filter((Iterable)threadNodes, ThreadNode.class)) {
                this.buildChildrenEntries(object);
            }
        } else {
            return new ITimeGraphEntry[0];
        }
        this.fFlameGraphEntries.sort(this.fThreadComparator);
        return this.fFlameGraphEntries.toArray(new ITimeGraphEntry[this.fFlameGraphEntries.size()]);
    }

    private void buildChildrenEntries(ThreadNode threadNode) {
        FlamegraphDepthEntry threadEntry = new FlamegraphDepthEntry(threadNode.getSymbol().toString(), 0L, 0L, this.fFlameGraphEntries.size(), threadNode.getId());
        ArrayList<@NonNull E> childrenEntries = new ArrayList();
        ArrayDeque<Long> timestampStack = new ArrayDeque<Long>();
        timestampStack.push(0L);
        threadNode.getChildren().stream().sorted(Comparator.comparingLong(AggregatedCalledFunction::getDuration)).forEach(rootFunction -> {
            this.setData((AggregatedCalledFunction)rootFunction, childrenEntries, (Deque<Long>)timestampStack);
            long currentThreadDuration = (Long)timestampStack.pop() + rootFunction.getDuration();
            timestampStack.push(currentThreadDuration);
        });
        childrenEntries.forEach(arg_0 -> ((FlamegraphDepthEntry)threadEntry).addChild(arg_0));
        threadEntry.updateEndTime((Long)timestampStack.pop());
        this.fFlameGraphEntries.add(threadEntry);
    }

    public ITimeGraphEntry[] getChildren(Object parentElement) {
        return (ITimeGraphEntry[])this.fFlameGraphEntries.toArray(new TimeGraphEntry[this.fFlameGraphEntries.size()]);
    }

    public ITimeGraphEntry getParent(Object element) {
        return null;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public SortOption getSortOption() {
        return this.fSortOption;
    }

    public void setSortOption(SortOption sortOption) {
        this.fSortOption = sortOption;
        switch (sortOption) {
            case BY_NAME: {
                this.fThreadComparator = Objects.requireNonNull(Comparator.comparing(TimeGraphEntry::getName));
                break;
            }
            case BY_NAME_REV: {
                this.fThreadComparator = Objects.requireNonNull(Comparator.comparing(TimeGraphEntry::getName, Comparator.reverseOrder()));
                break;
            }
            case BY_ID: {
                this.fThreadComparator = Objects.requireNonNull(Comparator.comparingLong(FlamegraphDepthEntry::getId));
                break;
            }
            case BY_ID_REV: {
                this.fThreadComparator = Objects.requireNonNull(Comparator.comparing(FlamegraphDepthEntry::getId, Comparator.reverseOrder()));
                break;
            }
        }
        this.fFlameGraphEntries.sort(this.fThreadComparator);
    }
}

