/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.verifier;

import java.util.regex.Pattern;
import org.eclipse.swt.widgets.Control;
import org.eclipse.team.svn.core.BaseMessages;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.verifier.AbstractFormattedVerifier;

public class MultiLinePropertyVerifier
extends AbstractFormattedVerifier {
    protected static String ERROR_MESSAGE_INVALID_FORMAT = "Field '$FIELD_NAME$' contains malformed property in line ";

    public MultiLinePropertyVerifier(String fieldName) {
        super(fieldName);
        ERROR_MESSAGE_INVALID_FORMAT = SVNUIMessages.Verifier_MultiLineProperty_Main;
    }

    protected String getErrorMessageImpl(Control input) {
        String[] properties = this.getText(input).split(System.getProperty("line.separator"));
        int i = 0;
        while (i < properties.length) {
            String retVal;
            if (properties[i].length() != 0 && (retVal = this.validateProperty(properties[i], i)) != null) {
                return retVal;
            }
            ++i;
        }
        return null;
    }

    protected String getWarningMessageImpl(Control input) {
        return null;
    }

    protected String validateProperty(String property, int line) {
        String[] propNameValue = property.split("=", 2);
        if (propNameValue.length == 0 || propNameValue[0].length() == 0) {
            return String.valueOf(this.formatMainMessage(line)) + " " + SVNUIMessages.Verifier_MultiLineProperty_NameIsEmpty;
        }
        Pattern pattern = Pattern.compile("[a-zA-Z:_].*");
        if (!pattern.matcher(propNameValue[0]).matches()) {
            return String.valueOf(this.formatMainMessage(line)) + " " + SVNUIMessages.Verifier_MultiLineProperty_NotALetter;
        }
        pattern = Pattern.compile("[a-zA-Z0-9:\\-_\\.]+");
        if (!pattern.matcher(propNameValue[0]).matches()) {
            return String.valueOf(this.formatMainMessage(line)) + " " + SVNUIMessages.Verifier_MultiLineProperty_InvalidNameChar;
        }
        if (propNameValue.length < 2 || propNameValue[1].length() == 0) {
            return String.valueOf(this.formatMainMessage(line)) + " " + SVNUIMessages.Verifier_MultiLineProperty_EmptyValue;
        }
        return null;
    }

    protected String formatMainMessage(int line) {
        return BaseMessages.format((String)ERROR_MESSAGE_INVALID_FORMAT, (Object[])new Object[]{"$FIELD_NAME$", String.valueOf(line + 1)});
    }
}

