/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.synchronize.update.action;

import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.team.core.synchronize.FastSyncInfoFilter;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.svn.core.IStateFilter;
import org.eclipse.team.svn.core.operation.AbstractActionOperation;
import org.eclipse.team.svn.core.operation.CompositeOperation;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.operation.IPostCommitErrorsProvider;
import org.eclipse.team.svn.core.operation.IRevisionProvider;
import org.eclipse.team.svn.core.operation.local.AddToSVNWithPropertiesOperation;
import org.eclipse.team.svn.core.operation.local.ClearLocalStatusesOperation;
import org.eclipse.team.svn.core.operation.local.CommitOperation;
import org.eclipse.team.svn.core.operation.local.MarkAsMergedOperation;
import org.eclipse.team.svn.core.operation.local.RefreshResourcesOperation;
import org.eclipse.team.svn.core.resource.ILocalResource;
import org.eclipse.team.svn.core.resource.IResourceProvider;
import org.eclipse.team.svn.core.synchronize.UpdateSyncInfo;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.dialog.NotifyNodeKindChangedDialog;
import org.eclipse.team.svn.ui.extension.ExtensionsManager;
import org.eclipse.team.svn.ui.extension.factory.ICommitDialog;
import org.eclipse.team.svn.ui.operation.ClearUpdateStatusesOperation;
import org.eclipse.team.svn.ui.operation.ShowPostCommitErrorsOperation;
import org.eclipse.team.svn.ui.operation.TreatAsEditsOperation;
import org.eclipse.team.svn.ui.panel.local.CommitPanel;
import org.eclipse.team.svn.ui.synchronize.SVNChangeSetCapability;
import org.eclipse.team.svn.ui.synchronize.action.AbstractActionHelper;
import org.eclipse.team.svn.ui.synchronize.action.ISyncStateFilter;
import org.eclipse.team.svn.ui.utility.UIMonitorUtility;
import org.eclipse.team.svn.ui.utility.UnacceptableOperationNotificator;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;

public class OverrideAndCommitModelActionHelper
extends AbstractActionHelper {
    public static final IStateFilter SF_NEW = new IStateFilter.AbstractStateFilter(){

        protected boolean acceptImpl(ILocalResource local, IResource resource, String state, int mask) {
            return state == "New";
        }

        protected boolean allowsRecursionImpl(ILocalResource local, IResource resource, String state, int mask) {
            return true;
        }
    };

    public OverrideAndCommitModelActionHelper(IAction action, ISynchronizePageConfiguration configuration) {
        super(action, configuration);
    }

    public FastSyncInfoFilter getSyncInfoFilter() {
        return new FastSyncInfoFilter.SyncInfoDirectionFilter(new int[]{12, 4, 8}){

            public boolean select(SyncInfo info) {
                UpdateSyncInfo sync = (UpdateSyncInfo)info;
                return super.select(info) && !IStateFilter.SF_OBSTRUCTED.accept(sync.getLocalResource());
            }
        };
    }

    public IActionOperation getOperation() {
        String msg = null;
        boolean keepLocks = false;
        final IResource[][] resources = new IResource[1][];
        IResource[] treatAsEdits = null;
        IResource[] changedResources = this.getSyncInfoSelector().getSelectedResourcesRecursive(ISyncStateFilter.SF_OVERRIDE);
        IResource[] overrideResources = UnacceptableOperationNotificator.shrinkResourcesWithNotOnRespositoryParents(this.configuration.getSite().getShell(), changedResources);
        if (overrideResources != null && overrideResources.length > 0) {
            overrideResources = FileUtility.addOperableParents((IResource[])overrideResources, (IStateFilter)IStateFilter.SF_NOTONREPOSITORY);
            HashSet<IResource> allResourcesSet = new HashSet<IResource>(Arrays.asList(overrideResources));
            String proposedComment = SVNChangeSetCapability.getProposedComment(overrideResources);
            CommitPanel commitPanel = new CommitPanel(overrideResources, overrideResources, 1, proposedComment);
            ICommitDialog commitDialog = ExtensionsManager.getInstance().getCurrentCommitFactory().getCommitDialog(this.configuration.getSite().getShell(), allResourcesSet, commitPanel);
            if (commitDialog.open() != 0) {
                return null;
            }
            treatAsEdits = commitPanel.getTreatAsEdits();
            resources[0] = commitPanel.getSelectedResources().length == 0 ? null : commitPanel.getSelectedResources();
            msg = commitDialog.getMessage();
            keepLocks = commitPanel.getKeepLocks();
        }
        if (resources[0] == null) {
            return null;
        }
        CompositeOperation op = new CompositeOperation("Operation_UOverrideAndCommit", SVNUIMessages.class);
        if (treatAsEdits != null && treatAsEdits.length > 0) {
            op.add((IActionOperation)new TreatAsEditsOperation(treatAsEdits));
        }
        final MarkAsMergedOperation mergeOp = new MarkAsMergedOperation(resources[0], true, msg, keepLocks);
        op.add((IActionOperation)mergeOp);
        op.add((IActionOperation)new ShowPostCommitErrorsOperation((IPostCommitErrorsProvider)mergeOp));
        final IResource[] addition = FileUtility.getResourcesRecursive((IResource[])resources[0], (IStateFilter)SF_NEW);
        if (addition.length != 0) {
            IResourceProvider additionProvider = new IResourceProvider(){
                protected IResource[] result;

                public IResource[] getResources() {
                    if (this.result == null) {
                        HashSet<IResource> tAdd = new HashSet<IResource>(Arrays.asList(addition));
                        IResource[] restricted = mergeOp.getHavingDifferentNodeKind();
                        int i = 0;
                        while (i < restricted.length) {
                            if (restricted[i] instanceof IContainer) {
                                IResource[] restrictedChildren = FileUtility.getResourcesRecursive((IResource[])resources[0], (IStateFilter)IStateFilter.SF_ALL);
                                tAdd.removeAll(Arrays.asList(restrictedChildren));
                            } else {
                                tAdd.remove(restricted[i]);
                            }
                            ++i;
                        }
                        this.result = tAdd.toArray(new IResource[tAdd.size()]);
                    }
                    return this.result;
                }
            };
            op.add((IActionOperation)new AddToSVNWithPropertiesOperation(additionProvider, false), new IActionOperation[]{mergeOp});
            op.add((IActionOperation)new ClearLocalStatusesOperation(additionProvider));
        }
        CommitOperation mainOp = new CommitOperation((IResourceProvider)mergeOp, msg, true, keepLocks);
        IActionOperation[] dependsOn = new IActionOperation[]{mergeOp};
        op.add((IActionOperation)mainOp, dependsOn);
        op.add((IActionOperation)new AbstractActionOperation("Operation_UNodeKindChanged", SVNUIMessages.class){

            protected void runImpl(IProgressMonitor monitor) throws Exception {
                final IResource[] diffNodeKind = mergeOp.getHavingDifferentNodeKind();
                if (diffNodeKind.length > 0) {
                    UIMonitorUtility.getDisplay().syncExec(new Runnable(){

                        public void run() {
                            new NotifyNodeKindChangedDialog(UIMonitorUtility.getShell(), diffNodeKind).open();
                        }
                    });
                }
            }
        });
        op.add((IActionOperation)new ShowPostCommitErrorsOperation((IPostCommitErrorsProvider)mainOp));
        op.add((IActionOperation)new ClearUpdateStatusesOperation(resources[0]), new IActionOperation[]{mainOp});
        op.add((IActionOperation)new RefreshResourcesOperation(resources[0]));
        ExtensionsManager.getInstance().getCurrentCommitFactory().performAfterCommitTasks(op, (IRevisionProvider)mainOp, dependsOn, this.configuration.getSite().getPart());
        return op;
    }
}

