/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.action.remote;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.action.IAction;
import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.core.operation.AbstractActionOperation;
import org.eclipse.team.svn.core.operation.CompositeOperation;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.operation.IRevisionProvider;
import org.eclipse.team.svn.core.operation.remote.DeleteResourcesOperation;
import org.eclipse.team.svn.core.operation.remote.SetRevisionAuthorNameOperation;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.resource.IRepositoryRoot;
import org.eclipse.team.svn.core.utility.SVNUtility;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.action.AbstractRepositoryTeamAction;
import org.eclipse.team.svn.ui.dialog.DefaultDialog;
import org.eclipse.team.svn.ui.operation.RefreshRemoteResourcesOperation;
import org.eclipse.team.svn.ui.panel.common.CommentPanel;
import org.eclipse.team.svn.ui.repository.RepositoriesView;

public class DeleteAction
extends AbstractRepositoryTeamAction {
    public void runImpl(IAction action) {
        CommentPanel commentPanel = new CommentPanel(SVNUIMessages.DeleteAction_Comment_Title);
        DefaultDialog dialog = new DefaultDialog(this.getShell(), commentPanel);
        if (dialog.open() == 0) {
            IRepositoryResource[] resources = this.getSelectedRepositoryResources();
            IRepositoryResource[] commonParents = SVNUtility.getCommonParents((IRepositoryResource[])resources);
            DeleteResourcesOperation mainOp = new DeleteResourcesOperation(resources, commentPanel.getMessage());
            CompositeOperation op = new CompositeOperation(mainOp.getId(), mainOp.getMessagesClass());
            op.add((IActionOperation)mainOp);
            op.add((IActionOperation)new RefreshRemoteResourcesOperation(commonParents));
            op.add((IActionOperation)new AbstractActionOperation("", SVNUIMessages.class){

                protected void runImpl(IProgressMonitor monitor) throws Exception {
                    DeleteAction.this.getShell().getDisplay().syncExec(new Runnable(){

                        public void run() {
                            RepositoriesView view = RepositoriesView.instance();
                            if (view == null) {
                                return;
                            }
                            view.getRepositoryTree().fireEmptySelectionEvent();
                        }
                    });
                }

                public ISchedulingRule getSchedulingRule() {
                    return null;
                }
            });
            op.add((IActionOperation)new SetRevisionAuthorNameOperation((IRevisionProvider)mainOp, 4L), new IActionOperation[]{mainOp});
            this.runScheduled((IActionOperation)op);
        }
    }

    public boolean isEnabled() {
        IRepositoryResource[] resources = this.getSelectedRepositoryResources();
        int i = 0;
        while (i < resources.length) {
            IRepositoryLocation location = resources[i].getRepositoryLocation();
            if (resources[i].getUrl().equals(location.getRoot().getUrl()) || resources[i].getSelectedRevision().getKind() != SVNRevision.Kind.HEAD || resources[i] instanceof IRepositoryRoot && (((IRepositoryRoot)resources[i]).getKind() == 4 || ((IRepositoryRoot)resources[i]).getKind() == 0)) {
                return false;
            }
            ++i;
        }
        return resources.length > 0;
    }
}

