/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.operations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.mapping.provider.SynchronizationScopeManager;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSTeamProvider;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.client.Session;
import org.eclipse.team.internal.ccvs.core.client.UpdateMergableOnly;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.operations.SingleCommandOperation;
import org.eclipse.team.internal.ccvs.ui.operations.SingleProjectScopeManager;
import org.eclipse.team.internal.ccvs.ui.operations.SingleProjectSubscriberContext;
import org.eclipse.ui.IWorkbenchPart;

public class UpdateOnlyMergableOperation
extends SingleCommandOperation {
    List skippedFiles = new ArrayList();
    private final IProject project;

    public UpdateOnlyMergableOperation(IWorkbenchPart part, IProject project, IResource[] resources, Command.LocalOption[] localOptions) {
        super(part, UpdateOnlyMergableOperation.asResourceMappers(resources), localOptions);
        this.project = project;
    }

    @Override
    protected IStatus executeCommand(Session session, CVSTeamProvider provider, ICVSResource[] resources, boolean recurse, IProgressMonitor monitor) throws CVSException, InterruptedException {
        UpdateMergableOnly update = new UpdateMergableOnly();
        IStatus status = update.execute(session, Command.NO_GLOBAL_OPTIONS, this.getLocalOptions(recurse), resources, null, monitor);
        if (status.getSeverity() != 4) {
            this.addSkippedFiles(update.getSkippedFiles());
            return OK;
        }
        return status;
    }

    @Override
    protected String getTaskName() {
        return CVSUIMessages.UpdateOnlyMergeable_taskName;
    }

    @Override
    protected String getTaskName(CVSTeamProvider provider) {
        return NLS.bind((String)CVSUIMessages.UpdateOperation_0, (Object[])new String[]{provider.getProject().getName()});
    }

    protected void addSkippedFiles(IFile[] files) {
        this.skippedFiles.addAll(Arrays.asList(files));
    }

    public IFile[] getSkippedFiles() {
        return this.skippedFiles.toArray(new IFile[this.skippedFiles.size()]);
    }

    @Override
    protected ResourceMappingContext getResourceMappingContext() {
        return new SingleProjectSubscriberContext((Subscriber)CVSProviderPlugin.getPlugin().getCVSWorkspaceSubscriber(), false, this.project);
    }

    @Override
    protected SynchronizationScopeManager createScopeManager(boolean consultModels) {
        return new SingleProjectScopeManager(this.getJobName(), this.getSelectedMappings(), this.getResourceMappingContext(), consultModels, this.project);
    }
}

