/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.core.internal.channelmanager.iterators;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.runtime.interfaces.properties.IPropertiesContainer;
import org.eclipse.tcf.te.runtime.stepper.StepperAttributeUtil;
import org.eclipse.tcf.te.runtime.stepper.interfaces.IFullQualifiedId;
import org.eclipse.tcf.te.runtime.stepper.interfaces.IStepContext;
import org.eclipse.tcf.te.tcf.core.iterators.AbstractPeerStepGroupIterator;
import org.eclipse.tcf.te.tcf.core.util.persistence.PeerDataHelper;
import org.eclipse.tcf.te.tcf.core.va.ValueAddManager;
import org.eclipse.tcf.te.tcf.core.va.interfaces.IValueAdd;

public class ChainPeersIterator
extends AbstractPeerStepGroupIterator {
    final List<IPeer> peers = new ArrayList<IPeer>();

    public void initialize(IStepContext context, final IPropertiesContainer data, final IFullQualifiedId fullQualifiedId, IProgressMonitor monitor) throws CoreException {
        super.initialize(context, data, fullQualifiedId, monitor);
        final IPeer peer = this.getActivePeerContext(context, data, fullQualifiedId);
        final String peerId = peer.getID();
        final boolean useValueAdds = !StepperAttributeUtil.getBooleanProperty((String)"channel.noValueAdd", (IFullQualifiedId)fullQualifiedId, (IPropertiesContainer)data);
        this.peers.clear();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                String proxyConfiguration;
                int n;
                int n2;
                IValueAdd[] iValueAddArray;
                if (useValueAdds) {
                    IValueAdd[] valueAdds;
                    iValueAddArray = valueAdds = ValueAddManager.getInstance().getValueAdd(peer);
                    n2 = valueAdds.length;
                    n = 0;
                    while (n < n2) {
                        IValueAdd valueAdd = iValueAddArray[n];
                        IPeer valueAddPeer = valueAdd.getPeer(peerId);
                        if (valueAddPeer != null) {
                            ChainPeersIterator.this.peers.add(valueAddPeer);
                        }
                        ++n;
                    }
                }
                if ((proxyConfiguration = (String)peer.getAttributes().get("Proxies")) != null) {
                    iValueAddArray = PeerDataHelper.decodePeerList(proxyConfiguration);
                    n2 = iValueAddArray.length;
                    n = 0;
                    while (n < n2) {
                        IValueAdd proxy = iValueAddArray[n];
                        ChainPeersIterator.this.peers.add((IPeer)proxy);
                        ++n;
                    }
                }
                if (!StepperAttributeUtil.getBooleanProperty((String)"org.eclipse.tcf.te.tcf.locator.skip_peer_to_chain", (IFullQualifiedId)fullQualifiedId, (IPropertiesContainer)data)) {
                    ChainPeersIterator.this.peers.add(peer);
                }
            }
        };
        if (Protocol.isDispatchThread()) {
            runnable.run();
        } else {
            Protocol.invokeAndWait((Runnable)runnable);
        }
        this.setIterations(this.peers.size());
    }

    public void internalNext(IStepContext context, IPropertiesContainer data, IFullQualifiedId fullQualifiedId, IProgressMonitor monitor) throws CoreException {
        StepperAttributeUtil.setProperty((String)"org.eclipse.tcf.te.runtime.stepper.active_context", (IFullQualifiedId)fullQualifiedId, (IPropertiesContainer)data, (Object)this.peers.get(this.getIteration()));
    }
}

