/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.launch.ui.tabs;

import org.eclipse.core.runtime.Assert;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.dialogs.IMessageProvider;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.tcf.te.launch.ui.interfaces.ILaunchConfigurationTabFormPart;
import org.eclipse.tcf.te.launch.ui.tabs.AbstractLaunchConfigurationTab;
import org.eclipse.tcf.te.ui.forms.CustomFormToolkit;
import org.eclipse.tcf.te.ui.forms.FormLayoutFactory;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.ManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public abstract class AbstractFormsLaunchConfigurationTab
extends AbstractLaunchConfigurationTab {
    private CustomFormToolkit toolkit = null;
    ManagedForm mform = null;

    public void dispose() {
        if (this.mform != null) {
            this.mform.dispose();
            this.mform = null;
        }
        if (this.toolkit != null) {
            this.toolkit.dispose();
            this.toolkit = null;
        }
        super.dispose();
    }

    protected CustomFormToolkit createFormToolkit(Display display) {
        Assert.isNotNull((Object)display);
        return new CustomFormToolkit(new FormToolkit(display));
    }

    public final CustomFormToolkit getFormToolkit() {
        return this.toolkit;
    }

    public IManagedForm getManagedForm() {
        return this.mform;
    }

    public final void createControl(Composite parent) {
        Assert.isNotNull((Object)parent);
        this.toolkit = this.createFormToolkit(parent.getDisplay());
        Assert.isNotNull((Object)this.toolkit);
        ScrolledForm form = this.toolkit.createScrolledForm(parent, null, true);
        Assert.isNotNull((Object)form);
        this.setControl((Control)form);
        this.mform = new TabForm(this, form);
        BusyIndicator.showWhile((Display)parent.getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                AbstractFormsLaunchConfigurationTab.this.createFormContent((IManagedForm)AbstractFormsLaunchConfigurationTab.this.mform);
            }
        });
    }

    public void createFormContent(IManagedForm managedForm) {
        Assert.isNotNull((Object)managedForm);
        this.configureManagedForm(managedForm);
        this.doCreateFormContent(managedForm.getForm().getBody(), this.getFormToolkit());
        managedForm.reflow(true);
    }

    protected void configureManagedForm(IManagedForm managedForm) {
        Assert.isNotNull((Object)managedForm);
        Composite body = managedForm.getForm().getBody();
        body.setLayout((Layout)FormLayoutFactory.createFormGridLayout((boolean)false, (int)1));
        if (this.getContextHelpId() != null) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)managedForm.getForm(), this.getContextHelpId());
        }
    }

    protected String getContextHelpId() {
        return null;
    }

    protected abstract void doCreateFormContent(Composite var1, CustomFormToolkit var2);

    public void initializeFrom(ILaunchConfiguration configuration) {
        if (this.mform != null) {
            IFormPart[] parts;
            this.mform.setInput((Object)configuration);
            IFormPart[] iFormPartArray = parts = this.mform.getParts();
            int n = parts.length;
            int n2 = 0;
            while (n2 < n) {
                IFormPart part = iFormPartArray[n2];
                if (part instanceof ILaunchConfigurationTabFormPart) {
                    ((ILaunchConfigurationTabFormPart)part).initializeFrom(configuration);
                }
                ++n2;
            }
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        if (this.mform != null) {
            IFormPart[] parts;
            IFormPart[] iFormPartArray = parts = this.mform.getParts();
            int n = parts.length;
            int n2 = 0;
            while (n2 < n) {
                IFormPart part = iFormPartArray[n2];
                if (part instanceof ILaunchConfigurationTabFormPart) {
                    ((ILaunchConfigurationTabFormPart)part).performApply(configuration);
                }
                ++n2;
            }
        }
    }

    public boolean isValid(ILaunchConfiguration configuration) {
        boolean valid = super.isValid(configuration);
        String errorMessage = null;
        if (this.mform != null) {
            IFormPart[] parts;
            IFormPart[] iFormPartArray = parts = this.mform.getParts();
            int n = parts.length;
            int n2 = 0;
            while (n2 < n) {
                IFormPart part = iFormPartArray[n2];
                if (part instanceof ILaunchConfigurationTabFormPart && !(valid &= ((ILaunchConfigurationTabFormPart)part).isValid(configuration)) && part instanceof IMessageProvider && errorMessage == null) {
                    errorMessage = ((IMessageProvider)part).getMessage();
                }
                ++n2;
            }
        }
        this.setErrorMessage(errorMessage);
        return valid;
    }

    private static class TabForm
    extends ManagedForm {
        public TabForm(AbstractFormsLaunchConfigurationTab parentTab, ScrolledForm form) {
            super(parentTab.getFormToolkit().getFormToolkit(), form);
            this.setContainer((Object)parentTab);
        }

        public AbstractFormsLaunchConfigurationTab getParentTab() {
            return (AbstractFormsLaunchConfigurationTab)((Object)this.getContainer());
        }

        public void dirtyStateChanged() {
            this.getParentTab().updateLaunchConfigurationDialog();
        }

        public void staleStateChanged() {
            this.getParentTab().updateLaunchConfigurationDialog();
        }
    }
}

