/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.rse.processes;

import java.math.BigInteger;
import java.text.NumberFormat;
import java.util.ArrayList;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.rse.core.model.ISystemResourceSet;
import org.eclipse.rse.core.model.SystemMessageObject;
import org.eclipse.rse.core.model.SystemRemoteResourceSet;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.internal.processes.ui.actions.SystemKillProcessAction;
import org.eclipse.rse.services.clientserver.processes.HostProcessFilterImpl;
import org.eclipse.rse.services.clientserver.processes.IHostProcess;
import org.eclipse.rse.services.clientserver.processes.IHostProcessFilter;
import org.eclipse.rse.subsystems.processes.core.subsystem.IRemoteProcess;
import org.eclipse.rse.subsystems.processes.core.subsystem.IRemoteProcessSubSystem;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.eclipse.rse.ui.SystemMenuManager;
import org.eclipse.rse.ui.actions.SystemCopyToClipboardAction;
import org.eclipse.rse.ui.view.AbstractSystemViewAdapter;
import org.eclipse.rse.ui.view.ISystemRemoteElementAdapter;
import org.eclipse.rse.ui.view.ISystemViewElementAdapter;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tcf.internal.rse.Activator;
import org.eclipse.tcf.internal.rse.Messages;
import org.eclipse.tcf.internal.rse.processes.TCFProcessAdapter;
import org.eclipse.tcf.internal.rse.processes.TCFProcessResource;
import org.eclipse.tcf.internal.rse.processes.TCFRemoteProcess;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class TCFSystemViewRemoteProcessAdapter
extends AbstractSystemViewAdapter
implements ISystemViewElementAdapter,
ISystemRemoteElementAdapter {
    private SystemCopyToClipboardAction copyClipboardAction;
    private static final Object[] EMPTY_LIST = new Object[0];
    private static IPropertyDescriptor[] properties = null;
    private SystemKillProcessAction killProcessAction;
    private static final NumberFormat percent_format = NumberFormat.getPercentInstance();

    static {
        percent_format.setMaximumFractionDigits(3);
    }

    public boolean canDrag(Object element) {
        return true;
    }

    public boolean canDrag(SystemRemoteResourceSet elements) {
        return true;
    }

    public Object doDrag(Object element, boolean sameSystemType, IProgressMonitor monitor) {
        return this.getText(element);
    }

    public ISystemResourceSet doDrag(SystemRemoteResourceSet set, IProgressMonitor monitor) {
        return set;
    }

    public void addActions(SystemMenuManager menu, IStructuredSelection selection, Shell parent, String menuGroup) {
        if (this.killProcessAction == null) {
            this.killProcessAction = new SystemKillProcessAction(this.getShell());
        }
        menu.add("group.change", (IAction)this.killProcessAction);
        if (this.copyClipboardAction == null) {
            Clipboard clipboard = RSEUIPlugin.getTheSystemRegistryUI().getSystemClipboard();
            this.copyClipboardAction = new SystemCopyToClipboardAction(this.getShell(), clipboard);
        }
        menu.add(menuGroup, (IAction)this.copyClipboardAction);
    }

    public ISubSystem getSubSystem(Object element) {
        if (element instanceof IRemoteProcess) {
            IRemoteProcess process = (IRemoteProcess)element;
            return process.getParentRemoteProcessSubSystem();
        }
        return super.getSubSystem(element);
    }

    public ImageDescriptor getImageDescriptor(Object element) {
        IRemoteProcess process = (IRemoteProcess)element;
        TCFProcessResource r = (TCFProcessResource)((Object)process.getObject());
        String state = r.getState();
        if (r.getParentID() != null) {
            if (state == null || state.indexOf(82) >= 0) {
                return Activator.getDefault().getImageDescriptorFromPath("icons/thread-r.gif");
            }
            return Activator.getDefault().getImageDescriptorFromPath("icons/thread-s.gif");
        }
        if (state == null || state.indexOf(82) >= 0) {
            return Activator.getDefault().getImageDescriptorFromPath("icons/process-r.gif");
        }
        return Activator.getDefault().getImageDescriptorFromPath("icons/process-s.gif");
    }

    public String getText(Object element) {
        String text = ((IRemoteProcess)element).getLabel();
        return text == null ? "" : text;
    }

    public String getAlternateText(Object element) {
        IRemoteProcess process = (IRemoteProcess)element;
        String allProperties = process.getAllProperties();
        return allProperties.replace('|', '\t');
    }

    public String getAbsoluteName(Object object) {
        IRemoteProcess process = (IRemoteProcess)object;
        return "" + process.getPid();
    }

    public String getType(Object element) {
        return "Process";
    }

    public Object getParent(Object element) {
        IRemoteProcess process = (IRemoteProcess)element;
        IRemoteProcess parent = process.getParentRemoteProcess();
        if (parent != null && parent.getAbsolutePath().equals(process.getAbsolutePath())) {
            parent = null;
        }
        return parent;
    }

    public boolean hasChildren(IAdaptable element) {
        return this.getChildren(element, (IProgressMonitor)new NullProgressMonitor()).length > 0;
    }

    public Object[] getChildren(IAdaptable element, IProgressMonitor monitor) {
        IRemoteProcess process = (IRemoteProcess)element;
        IRemoteProcessSubSystem ss = process.getParentRemoteProcessSubSystem();
        IHostProcessFilter orgRpfs = process.getFilterString();
        HostProcessFilterImpl newRpfs = new HostProcessFilterImpl(orgRpfs.toString());
        Object[] children1 = null;
        Object[] children2 = null;
        newRpfs.setPpid(Long.toString(process.getPid()));
        try {
            TCFProcessResource r = (TCFProcessResource)((Object)process.getObject());
            IHostProcess[] nodes = r.getService().listAllProcesses(orgRpfs, r, monitor);
            TCFProcessAdapter adapter = new TCFProcessAdapter();
            children1 = adapter.convertToRemoteProcesses(process.getContext(), process, nodes);
            if (children1 == null) {
                children1 = EMPTY_LIST;
            }
            if ((children2 = ss.listAllProcesses((IHostProcessFilter)newRpfs, process.getContext(), monitor)) == null) {
                children2 = EMPTY_LIST;
            }
        }
        catch (Exception exc) {
            children1 = new SystemMessageObject[]{new SystemMessageObject(RSEUIPlugin.getPluginMessage((String)"RSEG1098"), 0, (Object)element)};
            children2 = null;
            SystemBasePlugin.logError((String)"Exception resolving file filter strings", (Throwable)exc);
        }
        if (children1 == null || children1.length == 0) {
            return children2;
        }
        if (children2 == null || children2.length == 0) {
            return children1;
        }
        Object[] children = new Object[children1.length + children2.length];
        System.arraycopy(children1, 0, children, 0, children1.length);
        System.arraycopy(children2, 0, children, children1.length, children2.length);
        return children;
    }

    protected IPropertyDescriptor[] internalGetPropertyDescriptors() {
        if (properties != null) {
            return properties;
        }
        ArrayList<PropertyDescriptor> l = new ArrayList<PropertyDescriptor>();
        l.add(TCFSystemViewRemoteProcessAdapter.createSimplePropertyDescriptor((String)"ID", (String)Messages.PROCESS_ID_LABEL, (String)Messages.PROCESS_ID_TOOLTIP));
        l.add(TCFSystemViewRemoteProcessAdapter.createSimplePropertyDescriptor((String)"PID", (String)Messages.PROCESS_PID_LABEL, (String)Messages.PROCESS_PID_TOOLTIP));
        l.add(TCFSystemViewRemoteProcessAdapter.createSimplePropertyDescriptor((String)"File", (String)Messages.PROCESS_NAME_LABEL, (String)Messages.PROCESS_NAME_TOOLTIP));
        l.add(TCFSystemViewRemoteProcessAdapter.createSimplePropertyDescriptor((String)"CWD", (String)Messages.PROCESS_CWD_LABEL, (String)Messages.PROCESS_CWD_TOOLTIP));
        l.add(TCFSystemViewRemoteProcessAdapter.createSimplePropertyDescriptor((String)"Root", (String)Messages.PROCESS_ROOT_LABEL, (String)Messages.PROCESS_ROOT_TOOLTIP));
        l.add(TCFSystemViewRemoteProcessAdapter.createSimplePropertyDescriptor((String)"State", (String)Messages.PROCESS_STATE_LABEL, (String)Messages.PROCESS_STATE_TOOLTIP));
        l.add(TCFSystemViewRemoteProcessAdapter.createSimplePropertyDescriptor((String)"UID", (String)Messages.PROCESS_UID_LABEL, (String)Messages.PROCESS_UID_TOOLTIP));
        l.add(TCFSystemViewRemoteProcessAdapter.createSimplePropertyDescriptor((String)"UserName", (String)Messages.PROCESS_USERNAME_LABEL, (String)Messages.PROCESS_USERNAME_TOOLTIP));
        l.add(TCFSystemViewRemoteProcessAdapter.createSimplePropertyDescriptor((String)"UGID", (String)Messages.PROCESS_GID_LABEL, (String)Messages.PROCESS_GID_TOOLTIP));
        l.add(TCFSystemViewRemoteProcessAdapter.createSimplePropertyDescriptor((String)"GroupName", (String)Messages.PROCESS_GROUPNAME_LABEL, (String)Messages.PROCESS_GROUPNAME_TOOLTIP));
        l.add(TCFSystemViewRemoteProcessAdapter.createSimplePropertyDescriptor((String)"PPID", (String)Messages.PROCESS_PPID_LABEL, (String)Messages.PROCESS_PPID_TOOLTIP));
        l.add(TCFSystemViewRemoteProcessAdapter.createSimplePropertyDescriptor((String)"PGRP", (String)Messages.PROCESS_PGRP_LABEL, (String)Messages.PROCESS_PGRP_TOOLTIP));
        l.add(TCFSystemViewRemoteProcessAdapter.createSimplePropertyDescriptor((String)"TGID", (String)Messages.PROCESS_TGID_LABEL, (String)Messages.PROCESS_TGID_TOOLTIP));
        l.add(TCFSystemViewRemoteProcessAdapter.createSimplePropertyDescriptor((String)"TracerPID", (String)Messages.PROCESS_TRACERPID_LABEL, (String)Messages.PROCESS_TRACERPID_TOOLTIP));
        l.add(TCFSystemViewRemoteProcessAdapter.createSimplePropertyDescriptor((String)"VSize", (String)Messages.PROCESS_VMSIZE_LABEL, (String)Messages.PROCESS_VMSIZE_TOOLTIP));
        l.add(TCFSystemViewRemoteProcessAdapter.createSimplePropertyDescriptor((String)"RSS", (String)Messages.PROCESS_VMRSS_LABEL, (String)Messages.PROCESS_VMRSS_TOOLTIP));
        l.add(TCFSystemViewRemoteProcessAdapter.createSimplePropertyDescriptor((String)"Session", (String)Messages.PROCESS_SESSION_LABEL, (String)Messages.PROCESS_SESSION_TOOLTIP));
        l.add(TCFSystemViewRemoteProcessAdapter.createSimplePropertyDescriptor((String)"TTY", (String)Messages.PROCESS_TTY_LABEL, (String)Messages.PROCESS_TTY_TOOLTIP));
        l.add(TCFSystemViewRemoteProcessAdapter.createSimplePropertyDescriptor((String)"Flags", (String)Messages.PROCESS_FLAGS_LABEL, (String)Messages.PROCESS_FLAGS_TOOLTIP));
        l.add(TCFSystemViewRemoteProcessAdapter.createSimplePropertyDescriptor((String)"MinFlt", (String)Messages.PROCESS_MINFLT_LABEL, (String)Messages.PROCESS_MINFLT_TOOLTIP));
        l.add(TCFSystemViewRemoteProcessAdapter.createSimplePropertyDescriptor((String)"CMinFlt", (String)Messages.PROCESS_CMINFLT_LABEL, (String)Messages.PROCESS_CMINFLT_TOOLTIP));
        l.add(TCFSystemViewRemoteProcessAdapter.createSimplePropertyDescriptor((String)"MajFlt", (String)Messages.PROCESS_MAJFLT_LABEL, (String)Messages.PROCESS_MAJFLT_TOOLTIP));
        l.add(TCFSystemViewRemoteProcessAdapter.createSimplePropertyDescriptor((String)"CMajFlt", (String)Messages.PROCESS_CMAJFLT_LABEL, (String)Messages.PROCESS_CMAJFLT_TOOLTIP));
        l.add(TCFSystemViewRemoteProcessAdapter.createSimplePropertyDescriptor((String)"UTime", (String)Messages.PROCESS_UTIME_LABEL, (String)Messages.PROCESS_UTIME_TOOLTIP));
        l.add(TCFSystemViewRemoteProcessAdapter.createSimplePropertyDescriptor((String)"STime", (String)Messages.PROCESS_STIME_LABEL, (String)Messages.PROCESS_STIME_TOOLTIP));
        l.add(TCFSystemViewRemoteProcessAdapter.createSimplePropertyDescriptor((String)"CUTime", (String)Messages.PROCESS_CUTIME_LABEL, (String)Messages.PROCESS_CUTIME_TOOLTIP));
        l.add(TCFSystemViewRemoteProcessAdapter.createSimplePropertyDescriptor((String)"CSTime", (String)Messages.PROCESS_CSTIME_LABEL, (String)Messages.PROCESS_CSTIME_TOOLTIP));
        l.add(TCFSystemViewRemoteProcessAdapter.createSimplePropertyDescriptor((String)"PCUTime", (String)Messages.PROCESS_PC_UTIME_LABEL, (String)Messages.PROCESS_PC_UTIME_TOOLTIP));
        l.add(TCFSystemViewRemoteProcessAdapter.createSimplePropertyDescriptor((String)"PCSTime", (String)Messages.PROCESS_PC_STIME_LABEL, (String)Messages.PROCESS_PC_STIME_TOOLTIP));
        l.add(TCFSystemViewRemoteProcessAdapter.createSimplePropertyDescriptor((String)"Priority", (String)Messages.PROCESS_PRIORITY_LABEL, (String)Messages.PROCESS_PRIORITY_TOOLTIP));
        l.add(TCFSystemViewRemoteProcessAdapter.createSimplePropertyDescriptor((String)"Nice", (String)Messages.PROCESS_NICE_LABEL, (String)Messages.PROCESS_NICE_TOOLTIP));
        l.add(TCFSystemViewRemoteProcessAdapter.createSimplePropertyDescriptor((String)"ITRealValue", (String)Messages.PROCESS_ITREALVALUE_LABEL, (String)Messages.PROCESS_ITREALVALUE_TOOLTIP));
        l.add(TCFSystemViewRemoteProcessAdapter.createSimplePropertyDescriptor((String)"StartTime", (String)Messages.PROCESS_STARTTIME_LABEL, (String)Messages.PROCESS_STARTTIME_TOOLTIP));
        l.add(TCFSystemViewRemoteProcessAdapter.createSimplePropertyDescriptor((String)"RLimit", (String)Messages.PROCESS_RLIMIT_LABEL, (String)Messages.PROCESS_RLIMIT_TOOLTIP));
        l.add(TCFSystemViewRemoteProcessAdapter.createSimplePropertyDescriptor((String)"CodeStart", (String)Messages.PROCESS_CODESTART_LABEL, (String)Messages.PROCESS_CODESTART_TOOLTIP));
        l.add(TCFSystemViewRemoteProcessAdapter.createSimplePropertyDescriptor((String)"CodeEnd", (String)Messages.PROCESS_CODEEND_LABEL, (String)Messages.PROCESS_CODEEND_TOOLTIP));
        l.add(TCFSystemViewRemoteProcessAdapter.createSimplePropertyDescriptor((String)"StackStart", (String)Messages.PROCESS_STACKSTART_LABEL, (String)Messages.PROCESS_STACKSTART_TOOLTIP));
        l.add(TCFSystemViewRemoteProcessAdapter.createSimplePropertyDescriptor((String)"Signals", (String)Messages.PROCESS_SIGNALS_LABEL, (String)Messages.PROCESS_SIGNALS_TOOLTIP));
        l.add(TCFSystemViewRemoteProcessAdapter.createSimplePropertyDescriptor((String)"SigBlock", (String)Messages.PROCESS_SIGBLOCK_LABEL, (String)Messages.PROCESS_SIGBLOCK_TOOLTIP));
        l.add(TCFSystemViewRemoteProcessAdapter.createSimplePropertyDescriptor((String)"SigIgnore", (String)Messages.PROCESS_SIGIGNORE_LABEL, (String)Messages.PROCESS_SIGIGNORE_TOOLTIP));
        l.add(TCFSystemViewRemoteProcessAdapter.createSimplePropertyDescriptor((String)"SigCatch", (String)Messages.PROCESS_SIGCATCH_LABEL, (String)Messages.PROCESS_SIGCATCH_TOOLTIP));
        l.add(TCFSystemViewRemoteProcessAdapter.createSimplePropertyDescriptor((String)"WChan", (String)Messages.PROCESS_WCHAN_LABEL, (String)Messages.PROCESS_WCHAN_TOOLTIP));
        l.add(TCFSystemViewRemoteProcessAdapter.createSimplePropertyDescriptor((String)"NSwap", (String)Messages.PROCESS_NSWAP_LABEL, (String)Messages.PROCESS_NSWAP_TOOLTIP));
        l.add(TCFSystemViewRemoteProcessAdapter.createSimplePropertyDescriptor((String)"CNSwap", (String)Messages.PROCESS_CNSWAP_LABEL, (String)Messages.PROCESS_CNSWAP_TOOLTIP));
        l.add(TCFSystemViewRemoteProcessAdapter.createSimplePropertyDescriptor((String)"ExitSignal", (String)Messages.PROCESS_EXITSIGNAL_LABEL, (String)Messages.PROCESS_EXITSIGNAL_TOOLTIP));
        l.add(TCFSystemViewRemoteProcessAdapter.createSimplePropertyDescriptor((String)"Processor", (String)Messages.PROCESS_PROCESSOR_LABEL, (String)Messages.PROCESS_PROCESSOR_TOOLTIP));
        l.add(TCFSystemViewRemoteProcessAdapter.createSimplePropertyDescriptor((String)"RTPriority", (String)Messages.PROCESS_RTPRIORITY_LABEL, (String)Messages.PROCESS_RTPRIORITY_TOOLTIP));
        l.add(TCFSystemViewRemoteProcessAdapter.createSimplePropertyDescriptor((String)"Policy", (String)Messages.PROCESS_POLICY_LABEL, (String)Messages.PROCESS_POLICY_TOOLTIP));
        properties = l.toArray(new IPropertyDescriptor[l.size()]);
        return properties;
    }

    protected Object internalGetPropertyValue(Object property) {
        Object v = this.internalGetPropertyValueOrNull(property);
        if (v == null) {
            v = "";
        }
        return v;
    }

    private Object internalGetPropertyValueOrNull(Object property) {
        TCFRemoteProcess process = (TCFRemoteProcess)((Object)this.propertySourceInput);
        Object p = process.getProperties().get(property);
        if (property.equals("VSize")) {
            return NLS.bind((String)Messages.PROCESS_VMSIZE_VALUE, (Object)Long.toString(process.getVmSizeInKB()));
        }
        if (property.equals("RSS")) {
            return NLS.bind((String)Messages.PROCESS_VMRSS_VALUE, (Object)Long.toString(process.getVmRSSInKB()));
        }
        if (property.equals("Signals")) {
            return this.formatBitSet(p);
        }
        if (property.equals("SigBlock")) {
            return this.formatBitSet(p);
        }
        if (property.equals("SigCatch")) {
            return this.formatBitSet(p);
        }
        if (property.equals("SigIgnore")) {
            return this.formatBitSet(p);
        }
        if (property.equals("CodeStart")) {
            return this.formatHex(p);
        }
        if (property.equals("CodeEnd")) {
            return this.formatHex(p);
        }
        if (property.equals("StackStart")) {
            return this.formatHex(p);
        }
        if (property.equals("WChan")) {
            return this.formatHex(p);
        }
        if (property.equals("Flags")) {
            return this.formatBitSet(p);
        }
        if (property.equals("UTime")) {
            return this.formatTime(p);
        }
        if (property.equals("STime")) {
            return this.formatTime(p);
        }
        if (property.equals("CUTime")) {
            return this.formatTime(p);
        }
        if (property.equals("CSTime")) {
            return this.formatTime(p);
        }
        if (property.equals("StartTime")) {
            return this.formatTime(p);
        }
        if (property.equals("ITRealValue")) {
            return this.formatTime(p);
        }
        if (property.equals("PCUTime")) {
            return this.formatPercent(p);
        }
        if (property.equals("PCSTime")) {
            return this.formatPercent(p);
        }
        if (p != null) {
            return p.toString();
        }
        return null;
    }

    public Object getPropertyValue(Object property, boolean formatted) {
        if (formatted) {
            return this.getPropertyValue(property);
        }
        TCFRemoteProcess process = (TCFRemoteProcess)((Object)this.propertySourceInput);
        Object p = process.getProperties().get(property);
        if (p == null) {
            if (property.equals("PID")) {
                return 0L;
            }
            if (property.equals("PPID")) {
                return 0L;
            }
            if (property.equals("CodeStart")) {
                return BigInteger.ZERO;
            }
            if (property.equals("CodeEnd")) {
                return BigInteger.ZERO;
            }
            if (property.equals("StackStart")) {
                return BigInteger.ZERO;
            }
            if (property.equals("WChan")) {
                return BigInteger.ZERO;
            }
            if (property.equals("UTime")) {
                return 0L;
            }
            if (property.equals("STime")) {
                return 0L;
            }
            if (property.equals("CUTime")) {
                return 0L;
            }
            if (property.equals("CSTime")) {
                return 0L;
            }
            if (property.equals("StartTime")) {
                return 0L;
            }
            if (property.equals("ITRealValue")) {
                return 0L;
            }
            if (property.equals("PCUTime")) {
                return 0.0;
            }
            if (property.equals("PCSTime")) {
                return 0.0;
            }
            if (property.equals("CWD")) {
                return "";
            }
            if (property.equals("File")) {
                return "";
            }
        }
        return p;
    }

    private String formatPercent(Object o) {
        if (o instanceof Number) {
            Number n = (Number)o;
            return percent_format.format(n.doubleValue());
        }
        return null;
    }

    private String formatTime(Object o) {
        if (o instanceof Number) {
            BigInteger n = new BigInteger(o.toString());
            BigInteger[] s = n.divideAndRemainder(BigInteger.valueOf(1000L));
            BigInteger[] m = s[0].divideAndRemainder(BigInteger.valueOf(60L));
            BigInteger[] h = m[0].divideAndRemainder(BigInteger.valueOf(60L));
            StringBuffer buf = new StringBuffer();
            if (!h[0].equals(BigInteger.ZERO)) {
                buf.append(h[0]);
                buf.append("h ");
            }
            if (buf.length() > 0 || !h[1].equals(BigInteger.ZERO)) {
                buf.append(h[1]);
                buf.append("m ");
            }
            buf.append(m[1]);
            buf.append('.');
            String ms = s[1].toString();
            buf.append("000".substring(ms.length()));
            buf.append(ms);
            buf.append('s');
            return buf.toString();
        }
        if (o == null) {
            return null;
        }
        return o.toString();
    }

    private void formatHex(StringBuffer buf, BigInteger n, int cnt) {
        int d;
        BigInteger[] m = n.divideAndRemainder(BigInteger.valueOf(16L));
        if (cnt < 7 || !m[0].equals(BigInteger.ZERO)) {
            this.formatHex(buf, m[0], cnt + 1);
        }
        buf.append((char)((d = m[1].intValue()) <= 9 ? 48 + d : 97 + d - 10));
    }

    protected String formatHex(Object o) {
        if (o instanceof Number) {
            BigInteger n = o instanceof BigInteger ? (BigInteger)o : new BigInteger(o.toString());
            StringBuffer buf = new StringBuffer();
            buf.append("0x");
            this.formatHex(buf, n, 0);
            return buf.toString();
        }
        if (o == null) {
            return null;
        }
        return o.toString();
    }

    protected String formatBitSet(Object o) {
        if (o instanceof Number) {
            StringBuffer buf = new StringBuffer();
            long n = ((Number)o).longValue();
            int i = 0;
            while (i < 64) {
                if ((n & 1L << i) != 0L) {
                    if (buf.length() > 0) {
                        buf.append(',');
                    }
                    int i0 = i;
                    while (i < 63 && (n & 1L << i + 1) != 0L) {
                        ++i;
                    }
                    buf.append(i0);
                    if (i0 != i) {
                        buf.append("..");
                        buf.append(i);
                    }
                }
                ++i;
            }
            return buf.toString();
        }
        if (o == null) {
            return null;
        }
        return o.toString();
    }

    protected String formatState(String state) {
        return state;
    }

    public String getAbsoluteParentName(Object element) {
        IRemoteProcess process = (IRemoteProcess)element;
        IRemoteProcess parent = process.getParentRemoteProcess();
        if (parent != null) {
            return parent.getAbsolutePath();
        }
        return "/proc/0";
    }

    public Object getRemoteParent(Object element, IProgressMonitor monitor) throws Exception {
        return ((IRemoteProcess)element).getParentRemoteProcess();
    }

    public String[] getRemoteParentNamesInUse(Object element, IProgressMonitor monitor) throws Exception {
        String[] pids = EMPTY_STRING_LIST;
        IRemoteProcess process = (IRemoteProcess)element;
        String parentName = "" + process.getPPid();
        if (parentName.equals("-1")) {
            return pids;
        }
        Object[] children = this.getChildren((IAdaptable)process.getParentRemoteProcess(), monitor);
        if (children == null || children.length == 0) {
            return pids;
        }
        pids = new String[children.length];
        int idx = 0;
        while (idx < pids.length) {
            pids[idx] = "" + ((IRemoteProcess)children[idx]).getPid();
            ++idx;
        }
        return pids;
    }

    public String getRemoteSubType(Object element) {
        return null;
    }

    public String getRemoteType(Object element) {
        IRemoteProcess process = (IRemoteProcess)element;
        if (process.isRoot()) {
            return "rootprocess";
        }
        return "process";
    }

    public String getRemoteTypeCategory(Object element) {
        return "processes";
    }

    public String getSubSystemConfigurationId(Object element) {
        IRemoteProcess process = (IRemoteProcess)element;
        return process.getParentRemoteProcessSubSystem().getSubSystemConfiguration().getId();
    }

    public boolean refreshRemoteObject(Object oldElement, Object newElement) {
        return false;
    }

    public boolean supportsUserDefinedActions(Object object) {
        return false;
    }
}

