/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.resource;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.sphinx.emf.metamodel.IMetaModelDescriptor;
import org.eclipse.sphinx.emf.metamodel.MetaModelDescriptorRegistry;
import org.eclipse.sphinx.emf.model.IModelDescriptor;
import org.eclipse.sphinx.emf.model.ModelDescriptorRegistry;
import org.eclipse.sphinx.emf.resource.ExtendedResource;

public class ContextAwareProxyURIHelper {
    private static final String CONTEXT_AWARE_PROXY_URI_QUERY_KEY_TARGET_METAMODEL_DESCRIPTOR = "tgtMMD";
    private static final Pattern CONTEXT_AWARE_PROXY_URI_QUERY_FIELD_PATTERN_TARGET_METAMODEL_DESCRIPTOR = ContextAwareProxyURIHelper.createURIQueryValuePattern("tgtMMD");
    private static final String CONTEXT_AWARE_PROXY_URI_QUERY_KEY_CONTEXT_URI = "ctxURI";
    private static final Pattern CONTEXT_AWARE_PROXY_URI_QUERY_FIELD_PATTERN_CONTEXT_URI = ContextAwareProxyURIHelper.createURIQueryValuePattern("ctxURI");
    private static final int CONTEXT_AWARE_PROXY_URI_QUERY_VALUE_GROUP_IDX = 2;

    private static Pattern createURIQueryValuePattern(String key) {
        String amp = "&";
        String eq = "=";
        return Pattern.compile("([^" + amp + "]+" + amp + ")*" + key + eq + "([^" + amp + "]*)(" + amp + "[^" + amp + "]+)*");
    }

    public void augmentToContextAwareProxy(EObject proxy, Resource contextResource) {
        Assert.isNotNull((Object)proxy);
        Assert.isNotNull((Object)contextResource);
        StringBuilder targetMMDescriptorQueryField = null;
        IMetaModelDescriptor proxyMMDescriptor = MetaModelDescriptorRegistry.INSTANCE.getDescriptor(proxy);
        if (proxyMMDescriptor != null) {
            targetMMDescriptorQueryField = new StringBuilder();
            targetMMDescriptorQueryField.append(CONTEXT_AWARE_PROXY_URI_QUERY_KEY_TARGET_METAMODEL_DESCRIPTOR);
            targetMMDescriptorQueryField.append("=");
            targetMMDescriptorQueryField.append(proxyMMDescriptor.getIdentifier());
        }
        URI contextURI = null;
        IModelDescriptor contextModelDescriptor = ModelDescriptorRegistry.INSTANCE.getModel(contextResource);
        if (contextModelDescriptor != null) {
            IPath rootPath = contextModelDescriptor.getRoot().getFullPath();
            contextURI = URI.createPlatformResourceURI((String)rootPath.toString(), (boolean)true);
        } else {
            contextURI = contextResource.getURI();
        }
        StringBuilder contextURIQueryField = new StringBuilder();
        contextURIQueryField.append(CONTEXT_AWARE_PROXY_URI_QUERY_KEY_CONTEXT_URI);
        contextURIQueryField.append("=");
        contextURIQueryField.append(contextURI);
        URI proxyURI = ((InternalEObject)proxy).eProxyURI();
        StringBuilder newQuery = new StringBuilder();
        String oldQuery = proxyURI.query();
        if (oldQuery != null) {
            newQuery.append(oldQuery);
            newQuery.append("&");
        }
        if (targetMMDescriptorQueryField != null) {
            newQuery.append((CharSequence)targetMMDescriptorQueryField);
            newQuery.append("&");
        }
        newQuery.append((CharSequence)contextURIQueryField);
        proxyURI = proxyURI.trimQuery().appendQuery(newQuery.toString());
        ((InternalEObject)proxy).eSetProxyURI(proxyURI);
    }

    public URI trimProxyContextInfo(URI proxyURI) {
        String oldQuery = proxyURI.query();
        if (oldQuery == null) {
            return proxyURI;
        }
        StringBuilder newQuery = new StringBuilder();
        Matcher matcher = ExtendedResource.URI_QUERY_FIELD_PATTERN.matcher(oldQuery);
        while (matcher.find()) {
            String key = matcher.group(1);
            if (CONTEXT_AWARE_PROXY_URI_QUERY_KEY_TARGET_METAMODEL_DESCRIPTOR.equals(key) || CONTEXT_AWARE_PROXY_URI_QUERY_KEY_CONTEXT_URI.equals(key)) continue;
            if (newQuery.length() > 0) {
                newQuery.append("&");
            }
            newQuery.append(key);
            String value = matcher.group(2);
            if (value.isEmpty()) continue;
            newQuery.append("=");
            newQuery.append(value);
        }
        URI newURI = proxyURI.trimQuery();
        if (newQuery.length() == 0) {
            return newURI;
        }
        return newURI.appendQuery(newQuery.toString());
    }

    public String getTargetMetaModelDescriptorId(URI uri) {
        Matcher matcher;
        Assert.isNotNull((Object)uri);
        String query = uri.query();
        if (query != null && (matcher = CONTEXT_AWARE_PROXY_URI_QUERY_FIELD_PATTERN_TARGET_METAMODEL_DESCRIPTOR.matcher(query)).matches()) {
            return matcher.group(2);
        }
        return null;
    }

    public URI getContextURI(URI uri) {
        Matcher matcher;
        Assert.isNotNull((Object)uri);
        String query = uri.query();
        if (query != null && (matcher = CONTEXT_AWARE_PROXY_URI_QUERY_FIELD_PATTERN_CONTEXT_URI.matcher(query)).matches()) {
            String contextURI = matcher.group(2);
            return URI.createURI((String)contextURI);
        }
        IPath workspaceRootPath = ResourcesPlugin.getWorkspace().getRoot().getFullPath();
        return URI.createPlatformResourceURI((String)workspaceRootPath.toString(), (boolean)true);
    }
}

