/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.internal.metamodel.services;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.sphinx.emf.Activator;
import org.eclipse.sphinx.emf.internal.messages.Messages;
import org.eclipse.sphinx.emf.metamodel.IMetaModelDescriptor;
import org.eclipse.sphinx.emf.metamodel.MetaModelDescriptorRegistry;
import org.eclipse.sphinx.emf.metamodel.services.IMetaModelService;
import org.eclipse.sphinx.platform.util.ExtensionClassDescriptor;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;

public class MetaModelServiceDescriptor
extends ExtensionClassDescriptor<IMetaModelService> {
    private static final String ATTR_TYPE = "type";
    private static final String NODE_APPLICABLE_FOR = "applicableFor";
    private static final String ATTR_META_MODEL_DESCRIPTOR_ID_PATTERN = "metaModelDescriptorIdPattern";
    private String typeName;
    private Class<IMetaModelService> serviceType;
    private Set<String> mmDescIdPatterns;

    public MetaModelServiceDescriptor(IConfigurationElement configurationElement) {
        super(configurationElement);
        this.typeName = configurationElement.getAttribute(ATTR_TYPE);
        Assert.isNotNull((Object)this.typeName, (String)Messages.error_missingMetaModelServiceType);
        this.initMetaModelDescIdPatterns(configurationElement);
    }

    private void initMetaModelDescIdPatterns(IConfigurationElement configurationElement) {
        IConfigurationElement[] applicableForElements;
        this.mmDescIdPatterns = new HashSet<String>();
        IConfigurationElement[] iConfigurationElementArray = applicableForElements = configurationElement.getChildren(NODE_APPLICABLE_FOR);
        int n = applicableForElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement applicableFor = iConfigurationElementArray[n2];
            String mmDescIdPattern = applicableFor.getAttribute(ATTR_META_MODEL_DESCRIPTOR_ID_PATTERN);
            if (mmDescIdPattern != null) {
                this.mmDescIdPatterns.add(mmDescIdPattern);
            }
            ++n2;
        }
    }

    public String getTypeName() {
        return this.typeName;
    }

    public Class<IMetaModelService> getServiceType() {
        if (this.serviceType == null) {
            try {
                this.serviceType = Platform.getBundle((String)this.getContributorPluginId()).loadClass(this.typeName);
            }
            catch (Exception ex) {
                PlatformLogUtil.logAsError((Plugin)Activator.getPlugin(), (Object)ex);
            }
        }
        return this.serviceType;
    }

    public List<IMetaModelDescriptor> getMetaModelDescriptors() {
        ArrayList<IMetaModelDescriptor> mmDescriptors = new ArrayList<IMetaModelDescriptor>();
        for (String mmDescIdPattern : this.mmDescIdPatterns) {
            if (".*".equals(mmDescIdPattern) || ".+".equals(mmDescIdPattern)) {
                mmDescriptors.add(MetaModelDescriptorRegistry.ANY_MM);
                continue;
            }
            mmDescriptors.addAll(MetaModelDescriptorRegistry.INSTANCE.getDescriptors(mmDescIdPattern));
        }
        return mmDescriptors;
    }

    public Set<String> getUnknownMetaModelDescIdPatterns() {
        HashSet<String> result = new HashSet<String>();
        if (this.mmDescIdPatterns.isEmpty()) {
            return Collections.emptySet();
        }
        for (String mmDescIdPattern : this.mmDescIdPatterns) {
            if (".*".equals(mmDescIdPattern) || ".+".equals(mmDescIdPattern) || !MetaModelDescriptorRegistry.INSTANCE.getDescriptors(mmDescIdPattern).isEmpty()) continue;
            result.add(mmDescIdPattern);
        }
        return result;
    }

    public IMetaModelService newInstance() throws Exception {
        Class type = this.getType();
        try {
            Constructor constructor = type.getConstructor(Collection.class);
            return (IMetaModelService)constructor.newInstance(this.getMetaModelDescriptors());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return (IMetaModelService)type.newInstance();
        }
    }
}

