/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.forms.swt;

import java.util.List;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.localization.LabelTransformer;
import org.eclipse.sapphire.ui.Presentation;
import org.eclipse.sapphire.ui.SapphireAction;
import org.eclipse.sapphire.ui.SapphireActionGroup;
import org.eclipse.sapphire.ui.SapphireActionHandler;
import org.eclipse.sapphire.ui.SapphireActionSystemPart;
import org.eclipse.sapphire.ui.forms.swt.FormComponentPresentation;
import org.eclipse.sapphire.ui.forms.swt.GridLayoutUtil;
import org.eclipse.sapphire.ui.forms.swt.SapphireActionPresentationManager;
import org.eclipse.sapphire.ui.forms.swt.SapphireHotSpotsActionPresentation;
import org.eclipse.sapphire.ui.forms.swt.SapphireKeyboardActionPresentation;
import org.eclipse.sapphire.ui.forms.swt.TablePropertyEditorPresentation;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public final class SapphireTextCellEditor
extends TextCellEditor {
    private final Presentation presentation;
    private final StructuredViewer viewer;
    private final TablePropertyEditorPresentation.SelectionProvider selectionProvider;
    private final Element element;
    private final ValueProperty property;
    private final SapphireActionGroup actions;
    private Composite topComposite;
    private Composite innerComposite;
    private Text text;
    private boolean disableFocusLostHandler;
    private boolean isDefaultValue;
    private ISelection selectionPriorToActivation;

    public SapphireTextCellEditor(Presentation presentation, StructuredViewer parent, TablePropertyEditorPresentation.SelectionProvider selectionProvider, Element element, ValueProperty property, SapphireActionGroup actions, int style) {
        this.presentation = presentation;
        this.viewer = parent;
        this.selectionProvider = selectionProvider;
        this.element = element;
        this.property = property;
        this.actions = actions;
        this.setStyle(style);
        this.create((Composite)parent.getControl());
    }

    public void setMaxWidth(int maxWidth) {
        if (maxWidth == -1) {
            this.innerComposite.setLayoutData((Object)GridLayoutUtil.gdfill());
        } else {
            this.innerComposite.setLayoutData((Object)GridLayoutUtil.gdwhint(GridLayoutUtil.gd(), maxWidth));
        }
    }

    public void setHorizonalIndent(int horizontalIndent) {
        ((GridLayout)this.topComposite.getLayout()).marginLeft = horizontalIndent;
    }

    protected Object doGetValue() {
        if (this.isDefaultValue) {
            return null;
        }
        return super.doGetValue();
    }

    protected void doSetValue(Object value) {
        Value val = (Value)value;
        String str = val.text(true);
        super.doSetValue((Object)(str == null ? "" : str));
        this.isDefaultValue = val.text(false) == null && val.getDefaultContent() != null;
    }

    protected Control createControl(Composite parent) {
        int style = this.getStyle();
        this.topComposite = new Composite(parent, 0){

            public void addTraverseListener(TraverseListener listener) {
                SapphireTextCellEditor.this.text.addTraverseListener(listener);
            }

            public void removeTraverseListener(TraverseListener listener) {
                SapphireTextCellEditor.this.text.removeTraverseListener(listener);
            }
        };
        this.topComposite.setBackground(parent.getBackground());
        this.topComposite.setLayout((Layout)GridLayoutUtil.glayout(1, 0, 0));
        this.innerComposite = new Composite(this.topComposite, style);
        this.innerComposite.setLayoutData((Object)GridLayoutUtil.gdfill());
        this.innerComposite.setLayout((Layout)GridLayoutUtil.glayout(1 + this.actions.getActiveActions().size(), 0, 2, 0, 0));
        this.innerComposite.setBackground(parent.getBackground());
        this.setStyle(0);
        this.text = (Text)super.createControl(this.innerComposite);
        this.text.setLayoutData((Object)GridLayoutUtil.gdhfill());
        this.setStyle(style);
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                SapphireTextCellEditor.this.isDefaultValue = false;
            }
        });
        Listener actionHandlerListener = new Listener(){

            public void handle(Event event) {
                SapphireTextCellEditor.this.handleActionHandlerEvent(event);
            }
        };
        for (SapphireAction action : this.actions.getActions()) {
            for (SapphireActionHandler handler : action.getActiveHandlers()) {
                handler.attach(actionHandlerListener);
            }
        }
        SapphireActionPresentationManager actionPresentationManager = new SapphireActionPresentationManager(this.presentation, this.actions);
        CustomActionsPresentation buttonActionPresentation = new CustomActionsPresentation(actionPresentationManager);
        buttonActionPresentation.setParentComposite(this.innerComposite);
        buttonActionPresentation.render();
        SapphireKeyboardActionPresentation keyboardActionPresentation = new SapphireKeyboardActionPresentation(actionPresentationManager);
        keyboardActionPresentation.attach((Control)this.text);
        keyboardActionPresentation.render();
        return this.topComposite;
    }

    private void handleActionHandlerEvent(Event event) {
        if (event instanceof SapphireActionHandler.PreExecuteEvent) {
            this.disableFocusLostHandler = true;
        } else if (event instanceof SapphireActionHandler.PostExecuteEvent) {
            if (!this.text.isDisposed()) {
                String newTextValue = this.element.property(this.property).text(false);
                if (newTextValue == null) {
                    newTextValue = "";
                }
                this.text.setText(newTextValue);
                this.text.setFocus();
                this.text.setSelection(0, newTextValue.length());
            }
            this.disableFocusLostHandler = false;
        }
    }

    public void activate() {
        this.selectionPriorToActivation = this.viewer.getSelection();
        if (this.selectionProvider != null) {
            this.selectionProvider.setFakeSelection(this.selectionPriorToActivation);
        }
        this.viewer.setSelection((ISelection)StructuredSelection.EMPTY);
        super.activate();
        this.topComposite.layout(true, true);
    }

    public CellEditor.LayoutData getLayoutData() {
        return new CellEditor.LayoutData();
    }

    protected void focusLost() {
        if (!this.disableFocusLostHandler) {
            this.disableFocusLostHandler = true;
            super.focusLost();
            this.disableFocusLostHandler = false;
            this.viewer.setSelection(this.selectionPriorToActivation);
            if (this.selectionProvider != null) {
                this.selectionProvider.setFakeSelection(null);
            }
            this.selectionPriorToActivation = null;
        }
    }

    private static final class CustomActionsPresentation
    extends SapphireHotSpotsActionPresentation {
        private Composite parent;

        public CustomActionsPresentation(SapphireActionPresentationManager manager) {
            super(manager);
        }

        public void setParentComposite(Composite parent) {
            this.parent = parent;
        }

        @Override
        public void render() {
            final Cursor cursor = new Cursor((Device)this.parent.getDisplay(), 21);
            this.parent.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    cursor.dispose();
                }
            });
            final FormComponentPresentation context = (FormComponentPresentation)this.getManager().context();
            for (final SapphireAction action : this.getActions()) {
                final List<SapphireActionHandler> handlers = action.getActiveHandlers();
                final Label button = new Label(this.parent, 0);
                button.setLayoutData((Object)GridLayoutUtil.gd());
                button.setBackground(this.parent.getBackground());
                button.setImage(context.resources().image(action.getImage(11)));
                button.setCursor(cursor);
                button.setToolTipText(LabelTransformer.transform((String)action.getLabel(), (CapitalizationType)CapitalizationType.TITLE_STYLE, (boolean)false));
                this.registerHotSpot(action, new CustomHotSpot((Control)button));
                button.addMouseListener((MouseListener)new MouseAdapter(){

                    public void mouseUp(MouseEvent event) {
                        if (handlers.size() == 1) {
                            ((SapphireActionHandler)handlers.get(0)).execute(context);
                        } else {
                            this.displayActionHandlerChoice(action);
                        }
                    }
                });
                final Runnable updateActionEnablementStateOp = new Runnable(){

                    @Override
                    public void run() {
                        boolean enabled = false;
                        for (SapphireActionHandler handler : handlers) {
                            enabled = handler.isEnabled();
                            if (enabled) break;
                        }
                        if (!button.isDisposed()) {
                            button.setEnabled(enabled);
                        }
                    }
                };
                action.attach(new Listener(){

                    public void handle(Event event) {
                        if (event instanceof SapphireActionSystemPart.EnablementChangedEvent) {
                            updateActionEnablementStateOp.run();
                        }
                    }
                });
                updateActionEnablementStateOp.run();
            }
        }
    }

    private static final class CustomHotSpot
    extends SapphireHotSpotsActionPresentation.ControlHotSpot {
        public CustomHotSpot(Control control) {
            super(control);
        }

        @Override
        public Rectangle getBounds() {
            Rectangle bounds = super.getBounds();
            return new Rectangle(bounds.x, bounds.y - 3, bounds.width, bounds.height + 6);
        }
    }
}

