/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.diagram.editor;

import org.eclipse.sapphire.Color;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.PropertyValidationEvent;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.el.Function;
import org.eclipse.sapphire.modeling.el.FunctionResult;
import org.eclipse.sapphire.modeling.el.Literal;
import org.eclipse.sapphire.ui.diagram.editor.FunctionUtil;
import org.eclipse.sapphire.ui.diagram.editor.ShapePart;
import org.eclipse.sapphire.ui.diagram.editor.TextChangeEvent;
import org.eclipse.sapphire.ui.diagram.shape.def.FontDef;
import org.eclipse.sapphire.ui.diagram.shape.def.TextDef;
import org.eclipse.sapphire.ui.forms.swt.SwtUtil;

public class TextPart
extends ShapePart {
    private TextDef textDef;
    private Element modelElement;
    private Function textFunction;
    private FunctionResult functionResult;
    private Property property;
    private Listener propertyListener;

    @Override
    protected void init() {
        super.init();
        this.textDef = (TextDef)this.definition;
        this.modelElement = this.getModelElement();
        this.textFunction = (Function)this.textDef.getContent().content();
        this.functionResult = this.initExpression(this.modelElement, this.textFunction, String.class, null, new Runnable(){

            @Override
            public void run() {
                TextPart.this.broadcast(new TextChangeEvent(TextPart.this));
            }
        });
        this.property = FunctionUtil.getFunctionProperty(this.modelElement, this.functionResult);
        if (this.property != null) {
            this.propertyListener = new Listener(){

                public void handle(Event event) {
                    if (event instanceof PropertyValidationEvent) {
                        SwtUtil.runOnDisplayThread(new Runnable(){

                            @Override
                            public void run() {
                                TextPart.this.refreshValidation();
                            }
                        });
                    }
                }
            };
            this.property.attach(this.propertyListener);
        }
        this.setEditable(!(this.textFunction instanceof Literal));
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.functionResult != null) {
            this.functionResult.dispose();
        }
        if (this.property != null) {
            this.property.detach(this.propertyListener);
        }
    }

    @Override
    protected Status computeValidation() {
        if (this.property == null) {
            return Status.createOkStatus();
        }
        return this.property.validation();
    }

    public String getContent() {
        String value = null;
        if (this.functionResult != null) {
            value = (String)this.functionResult.value();
        }
        return value;
    }

    public FunctionResult getContentFunction() {
        return this.functionResult;
    }

    public Color getTextColor() {
        return (Color)this.textDef.getColor().content();
    }

    public FontDef getFontDef() {
        return this.textDef.getFont();
    }

    public boolean truncatable() {
        return (Boolean)this.textDef.isTruncatable().content();
    }

    public Property getTextProperty() {
        return this.property;
    }
}

