/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui;

import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.ui.forms.swt.SwtResourceCache;
import org.eclipse.sapphire.ui.forms.swt.SwtUtil;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;

public final class ProblemOverlayImageDescriptor
extends CompositeImageDescriptor {
    private static final ImageData IMG_ERROR_OVERLAY = SwtUtil.createImageData(SwtResourceCache.class, "ErrorOverlay.gif");
    private static final ImageData IMG_WARNING_OVERLAY = SwtUtil.createImageData(SwtResourceCache.class, "WarningOverlay.png");
    private final ImageData base;
    private final ImageData overlay;
    private final Point size;

    public ProblemOverlayImageDescriptor(ImageDescriptor base, Status.Severity severity) {
        this.base = base.getImageData();
        this.overlay = this.getOverlay(severity);
        this.size = new Point(this.base.width, this.base.height);
    }

    protected void drawCompositeImage(int width, int height) {
        this.drawImage(this.base, 0, 0);
        this.drawImage(this.overlay, 0, height - this.overlay.height);
    }

    protected Point getSize() {
        return this.size;
    }

    private ImageData getOverlay(Status.Severity severity) {
        if (severity == Status.Severity.ERROR) {
            return IMG_ERROR_OVERLAY;
        }
        if (severity == Status.Severity.WARNING) {
            return IMG_WARNING_OVERLAY;
        }
        throw new IllegalArgumentException();
    }
}

