/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui;

import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.sapphire.LoggingService;
import org.eclipse.sapphire.Sapphire;
import org.eclipse.swt.widgets.Display;

public final class DelayedTasksExecutor {
    private static final long DELAY = 300L;
    private static final long WORKER_THREAD_SHUTDOWN_DELAY = 600000L;
    private static final Task[] NO_TASKS = new Task[0];
    private static final TaskPriorityComparator TASK_PRIORITY_COMPARATOR = new TaskPriorityComparator();
    private static final Set<Task> tasks = new LinkedHashSet<Task>();
    private static long timeOfLastAddition = 0L;
    private static long timeOfLastWork = System.currentTimeMillis();
    private static WorkerThread workerThread = null;

    public static void schedule(final Task task) {
        DelayedTasksExecutor.syncExec(new Runnable(){

            @Override
            public void run() {
                boolean taskScheduled = false;
                for (Task t : tasks) {
                    if (t.subsumes(task)) {
                        taskScheduled = true;
                        break;
                    }
                    if (!task.subsumes(t)) continue;
                    tasks.remove(t);
                    break;
                }
                if (!taskScheduled) {
                    tasks.add(task);
                }
                timeOfLastAddition = System.currentTimeMillis();
                if (workerThread == null || !workerThread.isAlive()) {
                    timeOfLastWork = System.currentTimeMillis();
                    DelayedTasksExecutor.workerThread = new WorkerThread();
                    workerThread.start();
                }
            }
        });
    }

    public static void sweep() {
        DelayedTasksExecutor.process(true);
    }

    private static void process(final boolean doNotDelay) {
        DelayedTasksExecutor.syncExec(new Runnable(){

            @Override
            public void run() {
                Task[] tasksToProcess = NO_TASKS;
                if (!tasks.isEmpty()) {
                    boolean process = doNotDelay;
                    if (!process) {
                        long now = System.currentTimeMillis();
                        long diff = now - timeOfLastAddition;
                        boolean bl = process = diff >= 300L;
                    }
                    if (process) {
                        tasksToProcess = tasks.toArray(new Task[tasks.size()]);
                        tasks.clear();
                        timeOfLastAddition = 0L;
                    }
                }
                if (tasksToProcess.length > 0) {
                    Arrays.sort(tasksToProcess, TASK_PRIORITY_COMPARATOR);
                    Task[] taskArray = tasksToProcess;
                    int n = tasksToProcess.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Task task = taskArray[n2];
                        try {
                            task.run();
                        }
                        catch (Exception e) {
                            ((LoggingService)Sapphire.service(LoggingService.class)).log((Throwable)e);
                        }
                        ++n2;
                    }
                    timeOfLastWork = System.currentTimeMillis();
                }
            }
        });
    }

    private static void syncExec(Runnable op) {
        Display display = Display.getDefault();
        if (Thread.currentThread() == display.getThread()) {
            op.run();
        } else {
            display.syncExec(op);
        }
    }

    public static abstract class Task
    implements Runnable {
        public int getPriority() {
            return 0;
        }

        public boolean subsumes(Task task) {
            return this.equals(task);
        }
    }

    private static final class TaskPriorityComparator
    implements Comparator<Task> {
        private TaskPriorityComparator() {
        }

        @Override
        public int compare(Task t1, Task t2) {
            return t2.getPriority() - t1.getPriority();
        }
    }

    private static final class WorkerThread
    extends Thread {
        public WorkerThread() {
            super("Sapphire Delayed Tasks Executor");
        }

        @Override
        public void run() {
            while (true) {
                DelayedTasksExecutor.process(false);
                if (System.currentTimeMillis() - timeOfLastWork >= 600000L) {
                    return;
                }
                try {
                    WorkerThread.sleep(300L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }
}

