/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.completion.rcp;

import com.google.common.annotations.Beta;
import com.google.common.base.Optional;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.codeassist.CompletionEngine;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.recommenders.internal.completion.rcp.AccessibleCompletionProposal;
import org.eclipse.recommenders.utils.names.IFieldName;
import org.eclipse.recommenders.utils.names.ITypeName;
import org.eclipse.recommenders.utils.names.Names;

@Beta
public class AccessibleCompletionProposals {
    public static AccessibleCompletionProposal newFieldRef(IField field, int completionOffset, int prefixLength, int relevance) {
        AccessibleCompletionProposal proposal = new AccessibleCompletionProposal(2, completionOffset);
        String typeSignature = "";
        try {
            typeSignature = field.getTypeSignature();
        }
        catch (JavaModelException javaModelException) {}
        String simpleName = Signature.getSignatureSimpleName((String)typeSignature);
        proposal.setTypeName(simpleName.toCharArray());
        proposal.setSignature(typeSignature.toCharArray());
        proposal.setName(field.getElementName().toCharArray());
        proposal.setCompletion(field.getElementName().toCharArray());
        try {
            proposal.setFlags(field.getFlags());
        }
        catch (JavaModelException javaModelException) {}
        int replaceStartIndex = completionOffset - prefixLength;
        int replaceEndIndex = completionOffset;
        proposal.setReplaceRange(replaceStartIndex, replaceEndIndex);
        int tokenStartIndex = replaceStartIndex;
        int tokenEndIndex = replaceEndIndex;
        proposal.setTokenRange(tokenStartIndex, tokenEndIndex);
        proposal.setRelevance(relevance);
        proposal.setData(IField.class, (Object)field);
        proposal.setData(IJavaProject.class, (Object)field.getJavaProject());
        return proposal;
    }

    public static AccessibleCompletionProposal newLocalRef(ILocalVariable local, int completionOffset, int prefixLength, int relevance) {
        AccessibleCompletionProposal proposal = new AccessibleCompletionProposal(5, completionOffset);
        String typeSignature = local.getTypeSignature();
        String simpleName = Signature.getSignatureSimpleName((String)typeSignature);
        proposal.setTypeName(simpleName.toCharArray());
        proposal.setSignature(typeSignature.toCharArray());
        proposal.setName(local.getElementName().toCharArray());
        proposal.setCompletion(local.getElementName().toCharArray());
        proposal.setFlags(local.getFlags());
        int replaceStartIndex = completionOffset - prefixLength;
        int replaceEndIndex = completionOffset;
        proposal.setReplaceRange(replaceStartIndex, replaceEndIndex);
        int tokenStartIndex = replaceStartIndex;
        int tokenEndIndex = replaceEndIndex;
        proposal.setTokenRange(tokenStartIndex, tokenEndIndex);
        proposal.setRelevance(relevance);
        return proposal;
    }

    public static AccessibleCompletionProposal newLocalRef(LocalVariableBinding local, int completionOffset, int prefixLength, int relevance) {
        AccessibleCompletionProposal proposal = new AccessibleCompletionProposal(5, completionOffset);
        if (local.type == null) {
            proposal.setTypeName(local.declaration.type.toString().toCharArray());
            proposal.setSignature(CompletionEngine.createTypeSignature((char[])CharOperation.NO_CHAR, (char[])local.declaration.type.toString().toCharArray()));
        } else {
            proposal.setTypeName(local.type.qualifiedSourceName());
            proposal.setPackageName(local.type.qualifiedPackageName());
            proposal.setSignature(CompletionEngine.getSignature((TypeBinding)local.type));
        }
        proposal.setName(local.name);
        proposal.setCompletion(local.name);
        proposal.setFlags(local.modifiers);
        int replaceStartIndex = completionOffset - prefixLength;
        int replaceEndIndex = completionOffset;
        proposal.setReplaceRange(replaceStartIndex, replaceEndIndex);
        int tokenStartIndex = replaceStartIndex;
        int tokenEndIndex = replaceEndIndex;
        proposal.setTokenRange(tokenStartIndex, tokenEndIndex);
        proposal.setRelevance(relevance);
        return proposal;
    }

    public static AccessibleCompletionProposal newTypeImport(ITypeName type) {
        if (type.isArrayType()) {
            type = type.getArrayBaseType();
        }
        char[] signature = (String.valueOf(Names.vm2srcQualifiedType((ITypeName)type)) + ";").toCharArray();
        AccessibleCompletionProposal res = new AccessibleCompletionProposal(23, 0);
        res.setSignature(signature);
        return res;
    }

    public static AccessibleCompletionProposal newQualifiedFieldRef(IFieldName field, int completionOffset, int prefixLength, int relevance) {
        String declaringType = field.getDeclaringType().getClassName();
        String fieldName = field.getFieldName();
        String completion = String.valueOf(declaringType) + "." + fieldName;
        char[] signature = (String.valueOf(field.getDeclaringType().getIdentifier().replace('/', '.')) + ";").toCharArray();
        AccessibleCompletionProposal fieldRef = new AccessibleCompletionProposal(2, 0);
        fieldRef.setDeclarationSignature(signature);
        fieldRef.setName(fieldName.toCharArray());
        fieldRef.setReplaceRange(completionOffset - prefixLength, completionOffset);
        fieldRef.setRequiredProposals(new CompletionProposal[]{AccessibleCompletionProposals.newTypeImport(field.getDeclaringType())});
        AccessibleCompletionProposal res = new AccessibleCompletionProposal(23, completionOffset);
        res.setCompletion(completion.toCharArray());
        res.setSignature(signature);
        res.setRelevance(relevance);
        return res;
    }

    public static Optional<AccessibleCompletionProposal> newMethodRef(IMethod method, int completionOffset, int prefixLength, int relevance) {
        String returnType;
        String completion = String.valueOf(method.getElementName()) + "()";
        String[] params = method.getParameterTypes();
        String[] resolved = new String[params.length];
        IType declaringType = method.getDeclaringType();
        int lastParam = params.length - 1;
        int i = 0;
        while (i <= lastParam) {
            String resolvedParam = params[i];
            String unresolvedParam = params[i];
            resolvedParam = (String)AccessibleCompletionProposals.resolveToBinary(unresolvedParam, declaringType).orNull();
            if (resolvedParam == null) {
                return Optional.absent();
            }
            resolved[i] = resolvedParam;
            ++i;
        }
        try {
            returnType = (String)AccessibleCompletionProposals.resolveToBinary(method.getReturnType(), declaringType).orNull();
        }
        catch (JavaModelException e) {
            e.printStackTrace();
            return Optional.absent();
        }
        if (returnType == null) {
            return Optional.absent();
        }
        AccessibleCompletionProposal res = new AccessibleCompletionProposal(6, relevance);
        try {
            res.setFlags(method.getFlags());
        }
        catch (JavaModelException e1) {
            e1.printStackTrace();
        }
        res.setCompletion(completion.toCharArray());
        String declarationSignature = Signature.createTypeSignature((String)method.getDeclaringType().getFullyQualifiedName(), (boolean)true);
        res.setDeclarationSignature(declarationSignature.toCharArray());
        String signature = Signature.createMethodSignature((String[])resolved, (String)returnType);
        res.setSignature(signature.toCharArray());
        res.setName(method.getElementName().toCharArray());
        res.setReplaceRange(completionOffset - prefixLength, completionOffset);
        Object paramNames = new char[params.length][];
        try {
            String[] parameterNames = method.getParameterNames();
            int i2 = 0;
            while (i2 < ((char[][])paramNames).length) {
                paramNames[i2] = parameterNames[i2].toCharArray();
                ++i2;
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
            paramNames = CompletionEngine.createDefaultParameterNames((int)params.length);
        }
        res.setParameterNames((char[][])paramNames);
        res.setData(IMethod.class, (Object)method);
        res.setData(IJavaProject.class, (Object)method.getJavaProject());
        return Optional.of((Object)((Object)res));
    }

    private static Optional<String> resolveToBinary(String unresolvedParam, IType declaringType) {
        if (unresolvedParam.length() == 1) {
            return Optional.of((Object)unresolvedParam);
        }
        if ('L' == unresolvedParam.charAt(0)) {
            return Optional.of((Object)unresolvedParam);
        }
        String curr = Signature.getTypeErasure((String)unresolvedParam);
        try {
            curr = JavaModelUtil.getResolvedTypeName((String)curr, (IType)declaringType);
        }
        catch (JavaModelException e) {
            e.printStackTrace();
            return Optional.absent();
        }
        if (curr == null) {
            return Optional.absent();
        }
        return Optional.of((Object)("L" + curr + ";"));
    }
}

