/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ecl.data.internal.commands;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.rcptt.ecl.core.Command;
import org.eclipse.rcptt.ecl.core.CoreFactory;
import org.eclipse.rcptt.ecl.core.EclMap;
import org.eclipse.rcptt.ecl.core.EclMapEntry;
import org.eclipse.rcptt.ecl.core.EclString;
import org.eclipse.rcptt.ecl.data.commands.GetAttrs;
import org.eclipse.rcptt.ecl.data.internal.EclDataPlugin;
import org.eclipse.rcptt.ecl.data.objects.Attribute;
import org.eclipse.rcptt.ecl.data.objects.Tree;
import org.eclipse.rcptt.ecl.runtime.ICommandService;
import org.eclipse.rcptt.ecl.runtime.IProcess;

public class GetAttrsService
implements ICommandService {
    public IStatus service(Command command, IProcess context) throws InterruptedException, CoreException {
        GetAttrs gs = (GetAttrs)command;
        EObject object = gs.getObject();
        if (object instanceof Tree) {
            Tree tree = (Tree)object;
            EclMap map = this.getAttrsFromTree(tree);
            context.getOutput().write((Object)map);
            return Status.OK_STATUS;
        }
        return EclDataPlugin.createErr("This type of object is not supported by the command", new Object[0]);
    }

    private EclMap getAttrsFromTree(Tree tree) {
        EclMap map = CoreFactory.eINSTANCE.createEclMap();
        for (Attribute attr : tree.getAttributes()) {
            EclMapEntry entry = GetAttrsService.createMapEntry(attr.getName(), attr.getValue());
            map.getEntries().add((Object)entry);
        }
        return map;
    }

    private static EclMapEntry createMapEntry(String key, String value) {
        EclString keyString = CoreFactory.eINSTANCE.createEclString();
        keyString.setValue(key);
        EclString valueString = CoreFactory.eINSTANCE.createEclString();
        valueString.setValue(value);
        EclMapEntry entry = CoreFactory.eINSTANCE.createEclMapEntry();
        entry.setKey((EObject)keyString);
        entry.setValue((EObject)valueString);
        return entry;
    }
}

