/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.debug.ui.launching;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.qvtd.debug.launching.QVTcLaunchConstants;
import org.eclipse.qvtd.debug.ui.launching.MainTab;
import org.eclipse.qvtd.debug.ui.launching.ParameterRow;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public abstract class DirectionalMainTab<TX>
extends MainTab<TX>
implements QVTcLaunchConstants {
    private Composite directionGroup;
    protected Combo modeCombo;
    protected Combo directionCombo;
    protected Button viewCheckButton;

    @Override
    protected void createDirectionGroup(Group txGroup) {
        this.directionGroup = new Composite((Composite)txGroup, 0);
        GridLayout gl_directionGroup = new GridLayout(5, false);
        gl_directionGroup.marginWidth = 0;
        gl_directionGroup.marginHeight = 0;
        this.directionGroup.setLayout((Layout)gl_directionGroup);
        this.directionGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        Label modeLabel = new Label(this.directionGroup, 0);
        modeLabel.setSize(31, 15);
        modeLabel.setText("Mode");
        this.modeCombo = new Combo(this.directionGroup, 0);
        this.modeCombo.setToolTipText("Whether the execution\n- checks that the output corresponds to the input\n- creates new output model elements\n- updates existing model elements where possible ");
        this.modeCombo.setItems(new String[]{"ENFORCE - CREATE"});
        this.modeCombo.select(0);
        Label directionLabel = new Label(this.directionGroup, 0);
        directionLabel.setLayoutData((Object)new GridData(131072, 0x1000000, true, false, 1, 1));
        directionLabel.setText("Direction");
        this.directionCombo = new Combo(this.directionGroup, 0);
        this.directionCombo.setToolTipText("Select enforceable output domain to choose the direction of a multi-directional transformation");
        this.directionCombo.setItems(new String[]{"NONE"});
        this.directionCombo.select(0);
        this.viewCheckButton = new Button(this.directionGroup, 32);
        this.viewCheckButton.setToolTipText("Whether the output may be a view of a larger model, or must be the whole model.");
        this.viewCheckButton.setLayoutData((Object)new GridData(131072, 0x1000000, true, false, 1, 1));
        this.viewCheckButton.setText("Partial View");
        this.viewCheckButton.setEnabled(false);
    }

    @Override
    public void dispose() {
        this.cancelCompileJob(true);
        super.dispose();
    }

    @Override
    protected @NonNull String getDirection() {
        return this.directionCombo.getText();
    }

    @Override
    protected void initializeInternal(@NonNull ILaunchConfiguration configuration) throws CoreException {
        super.initializeInternal(configuration);
        ArrayList<String> directions = new ArrayList<String>();
        if (this.newOutputsGroup != null) {
            Control[] controlArray = this.newOutputsGroup.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                if (child instanceof ParameterRow) {
                    directions.add(((ParameterRow)child).name.getText());
                }
                ++n2;
            }
        }
        Collections.sort(directions);
        this.directionCombo.setItems(directions.toArray(new String[directions.size()]));
        this.directionCombo.setText(configuration.getAttribute("direction", "NONE"));
        this.modeCombo.setText(configuration.getAttribute("mode", "ENFORCE - CREATE"));
        this.viewCheckButton.setSelection(configuration.getAttribute("view", false));
    }

    @Override
    protected void initializeOptions(@NonNull Map<@NonNull String, @Nullable Map<// Could not load outer class - annotation placement on inner may be incorrect
     @NonNull CompilerChain.Key<Object>, @Nullable Object>> options) {
        super.initializeOptions(options);
        this.initializeURIOption(options, "QVTu");
        this.initializeURIOption(options, "QVTm");
        this.initializeURIOption(options, "QVTs");
        this.initializeURIOption(options, "QVTi");
    }

    @Override
    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        super.performApply(configuration);
        configuration.setAttribute("direction", this.directionCombo.getText());
        configuration.setAttribute("mode", this.modeCombo.getText());
        configuration.setAttribute("view", this.viewCheckButton.getSelection());
    }

    @Override
    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        super.setDefaults(configuration);
        configuration.setAttribute("direction", "NONE");
        configuration.setAttribute("mode", "ENFORCE - CREATE");
        configuration.setAttribute("view", false);
    }

    protected void setDirections(@NonNull Set<@NonNull String> enforceableDirectionNamees) {
        if (this.directionCombo.isDisposed()) {
            return;
        }
        String oldText = this.directionCombo.getText();
        Object[] directionItems = new String[enforceableDirectionNamees.size()];
        int newIndex = -1;
        int i = 0;
        for (String name : enforceableDirectionNamees) {
            if (ClassUtil.safeEquals((Object)name, (Object)oldText)) {
                newIndex = i;
            }
            directionItems[i++] = name;
        }
        Arrays.sort(directionItems);
        this.directionCombo.setItems((String[])directionItems);
        this.directionCombo.select(newIndex >= 0 ? newIndex : 0);
    }
}

