/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.remote.terminal;

import java.util.HashMap;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ptp.internal.remote.terminal.Util;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.tm.terminal.view.core.TerminalServiceFactory;
import org.eclipse.tm.terminal.view.core.interfaces.ITerminalService;
import org.eclipse.ui.handlers.HandlerUtil;

public class TerminalCommandHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection sel = HandlerUtil.getActiveMenuSelection((ExecutionEvent)event);
        IStructuredSelection selection = (IStructuredSelection)sel;
        Object firstElement = selection.getFirstElement();
        if (firstElement instanceof IProject) {
            IProject prj = ((IProject)firstElement).getProject();
            this.openTerminal(prj);
        }
        return null;
    }

    private void openTerminal(IProject prj) {
        IRemoteConnection irc = Util.getRemoteConnection(prj);
        if (irc != null) {
            HashMap<String, String> properties = new HashMap<String, String>();
            String connTypeId = irc.getConnectionType().getId();
            String connName = irc.getName();
            properties.put("ConnectionTypeId", connTypeId);
            properties.put("ConnectionName", connName);
            properties.put("delegateId", "org.eclipse.tm.terminal.connector.telnet.launcher.remote");
            ITerminalService terminal = TerminalServiceFactory.getService();
            if (terminal != null) {
                terminal.openConsole(properties, null);
            }
        }
    }
}

